package com.ovopark.boot.business.base.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import java.time.LocalDate;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;

/**
 * <p>
 * 
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2019-07-11
 */
@TableName("open_auth_user")
public class AuthUser implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户名称
     */
    private String username;

    /**
     * app id
     */
    private String applicationId;

    /**
     * app key
     */
    private String applicationKey;

    /**
     * 秘钥
     */
    private String applicationSecret;

    /**
     * 1正式；2测试
     */
    private Integer keytype;

    /**
     * 是否过期（1：永不过期；2：服务到期；3：服务中）
     */
    private Integer ifexpire;

    /**
     * 到期时间
     */
    private LocalDate expire;

    /**
     * 企业ID
     */
    private Long enterpriseId;

    /**
     * shopweb企业id
     */
    private Long shopwebEnterpriseId;

    /**
     * (1:启用；2禁用）
     */
    private String switchStatus;

    /**
     * 启用(禁用)时间
     */
    private LocalDateTime switchTime;

    /**
     * 供应商帐号
     */
    private String supplierAccount;

    /**
     * 开发者类型(1:管理员；2：普通；3：供应商)
     */
    private Integer developerType;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getApplicationId() {
        return applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    public String getApplicationKey() {
        return applicationKey;
    }

    public void setApplicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
    }

    public String getApplicationSecret() {
        return applicationSecret;
    }

    public void setApplicationSecret(String applicationSecret) {
        this.applicationSecret = applicationSecret;
    }

    public Integer getKeytype() {
        return keytype;
    }

    public void setKeytype(Integer keytype) {
        this.keytype = keytype;
    }

    public Integer getIfexpire() {
        return ifexpire;
    }

    public void setIfexpire(Integer ifexpire) {
        this.ifexpire = ifexpire;
    }

    public LocalDate getExpire() {
        return expire;
    }

    public void setExpire(LocalDate expire) {
        this.expire = expire;
    }

    public Long getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(Long enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public Long getShopwebEnterpriseId() {
        return shopwebEnterpriseId;
    }

    public void setShopwebEnterpriseId(Long shopwebEnterpriseId) {
        this.shopwebEnterpriseId = shopwebEnterpriseId;
    }

    public String getSwitchStatus() {
        return switchStatus;
    }

    public void setSwitchStatus(String switchStatus) {
        this.switchStatus = switchStatus;
    }

    public LocalDateTime getSwitchTime() {
        return switchTime;
    }

    public void setSwitchTime(LocalDateTime switchTime) {
        this.switchTime = switchTime;
    }

    public String getSupplierAccount() {
        return supplierAccount;
    }

    public void setSupplierAccount(String supplierAccount) {
        this.supplierAccount = supplierAccount;
    }

    public Integer getDeveloperType() {
        return developerType;
    }

    public void setDeveloperType(Integer developerType) {
        this.developerType = developerType;
    }

    @Override
    public String toString() {
        return "AuthUser{" +
        "id=" + id +
        ", username=" + username +
        ", applicationId=" + applicationId +
        ", applicationKey=" + applicationKey +
        ", applicationSecret=" + applicationSecret +
        ", keytype=" + keytype +
        ", ifexpire=" + ifexpire +
        ", expire=" + expire +
        ", enterpriseId=" + enterpriseId +
        ", shopwebEnterpriseId=" + shopwebEnterpriseId +
        ", switchStatus=" + switchStatus +
        ", switchTime=" + switchTime +
        ", supplierAccount=" + supplierAccount +
        ", developerType=" + developerType +
        "}";
    }
}
