package com.ovopark.boot.business.base.entity;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.io.Serializable;

/**
 * <p>
 * 
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2020-03-24
 */
@TableName("is_face_devices")
public class FaceDevices implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    private Integer depId;

    private Integer deviceId;

    private String deviceMac;

    private String deviceName;

    private Integer isPublic;

    private Integer groupId;

    /**
     * 1开放平台 2业务
     */
    private Integer isOpen;

    /**
     * 使用 updateById 更新字段为null 不更新问题,需要+上此注解
     * */
    @TableField(strategy = FieldStrategy.IGNORED) 
    private Long openEnterpriseId;
    
    @TableField(strategy = FieldStrategy.IGNORED) 
    private Long openDepId;

    private BigDecimal thresholdFacePlusPlus;

    private BigDecimal thresholdBaidu;

    private Integer intervalTime;

    private Integer faceExpirationTime;

    /**
     * 设备用途(1:业务平台推送；2：三方下行推送；3：颜值大屏websocket推送；4:门禁推送;5颜值安卓屏；6.信发;7:定制URL（is_face_device_callback）8.防损系统)
     */
    private String deviceUse;

    /**
     * 是否在白名单中（开放平台访问业务服务器但不推送）
     */
    private Boolean isWhiteList;

    /**
     * 三方对接的收银台id
     */
    private String machineId;

    private Integer isIn;

    /**
     * 俯仰角 [-90,90]
     */
    private Double anglePitch;

    /**
     * 平面内旋转角[-180,180]
     */
    private Double angleRoll;

    /**
     * 左右[-90,90]
     */
    private Double angleYaw;


    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getDepId() {
        return depId;
    }

    public void setDepId(Integer depId) {
        this.depId = depId;
    }

    public Integer getDeviceId() {
        return deviceId;
    }

    public void setDeviceId(Integer deviceId) {
        this.deviceId = deviceId;
    }

    public String getDeviceMac() {
        return deviceMac;
    }

    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    public String getDeviceName() {
        return deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public Integer getIsPublic() {
        return isPublic;
    }

    public void setIsPublic(Integer isPublic) {
        this.isPublic = isPublic;
    }

    public Integer getGroupId() {
        return groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public Integer getIsOpen() {
        return isOpen;
    }

    public void setIsOpen(Integer isOpen) {
        this.isOpen = isOpen;
    }

    public Long getOpenEnterpriseId() {
        return openEnterpriseId;
    }

    public void setOpenEnterpriseId(Long openEnterpriseId) {
        this.openEnterpriseId = openEnterpriseId;
    }

    public Long getOpenDepId() {
        return openDepId;
    }

    public void setOpenDepId(Long openDepId) {
        this.openDepId = openDepId;
    }

    public BigDecimal getThresholdFacePlusPlus() {
        return thresholdFacePlusPlus;
    }

    public void setThresholdFacePlusPlus(BigDecimal thresholdFacePlusPlus) {
        this.thresholdFacePlusPlus = thresholdFacePlusPlus;
    }

    public BigDecimal getThresholdBaidu() {
        return thresholdBaidu;
    }

    public void setThresholdBaidu(BigDecimal thresholdBaidu) {
        this.thresholdBaidu = thresholdBaidu;
    }

    public Integer getIntervalTime() {
        return intervalTime;
    }

    public void setIntervalTime(Integer intervalTime) {
        this.intervalTime = intervalTime;
    }

    public Integer getFaceExpirationTime() {
        return faceExpirationTime;
    }

    public void setFaceExpirationTime(Integer faceExpirationTime) {
        this.faceExpirationTime = faceExpirationTime;
    }

    public String getDeviceUse() {
        return deviceUse;
    }

    public void setDeviceUse(String deviceUse) {
        this.deviceUse = deviceUse;
    }

    public Boolean getWhiteList() {
        return isWhiteList;
    }

    public void setWhiteList(Boolean isWhiteList) {
        this.isWhiteList = isWhiteList;
    }

    public String getMachineId() {
        return machineId;
    }

    public void setMachineId(String machineId) {
        this.machineId = machineId;
    }

    public Integer getIsIn() {
        return isIn;
    }

    public void setIsIn(Integer isIn) {
        this.isIn = isIn;
    }

    public Double getAnglePitch() {
        return anglePitch;
    }

    public void setAnglePitch(Double anglePitch) {
        this.anglePitch = anglePitch;
    }

    public Double getAngleRoll() {
        return angleRoll;
    }

    public void setAngleRoll(Double angleRoll) {
        this.angleRoll = angleRoll;
    }

    public Double getAngleYaw() {
        return angleYaw;
    }

    public void setAngleYaw(Double angleYaw) {
        this.angleYaw = angleYaw;
    }

    @Override
    public String toString() {
        return "FaceDevices{" +
        "id=" + id +
        ", depId=" + depId +
        ", deviceId=" + deviceId +
        ", deviceMac=" + deviceMac +
        ", deviceName=" + deviceName +
        ", isPublic=" + isPublic +
        ", groupId=" + groupId +
        ", isOpen=" + isOpen +
        ", openEnterpriseId=" + openEnterpriseId +
        ", openDepId=" + openDepId +
        ", thresholdFacePlusPlus=" + thresholdFacePlusPlus +
        ", thresholdBaidu=" + thresholdBaidu +
        ", intervalTime=" + intervalTime +
        ", faceExpirationTime=" + faceExpirationTime +
        ", deviceUse=" + deviceUse +
        ", isWhiteList=" + isWhiteList +
        ", machineId=" + machineId +
        ", isIn=" + isIn +
        ", anglePitch=" + anglePitch +
        ", angleRoll=" + angleRoll +
        ", angleYaw=" + angleYaw +
        "}";
    }
}
