package com.ovopark.boot.business.base.entity.dto;

import java.io.Serializable;

/**
 * 该类用于记录一个用户的信息，对应于数据库中的is_roles表中的一条记录
 *
 * @author zzg
 */
public class RoleDto implements Serializable {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 5172547893953056484L;
    public static final int ISGRADES_TURE = 1;
    public static final int ISGRADES_FALSE = 0;

    public static final int GRADES_MANAGER = -4;//高管
    public static final int GRADES_CHECKER = -3;//督导
    public static final int GRADES_STORE_MANAGER = -2;//店长
    public static final int GRADES_PROFESSIONAL_LINE = -1;//专业线


    private Integer id; // 角色ID

    private String roleName; //角色名称

    private String privileges; //角色权限

    private Integer groupId;//公司ID

    private Integer applyToDept;//应用到门店 0:不应用 1应用
    private Integer isGrades = 0;//是否是职级字段，0否 1是 （默认为0）
    private Integer pid;//所属父类

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    public String getPrivileges() {
        return privileges;
    }

    public void setPrivileges(String privileges) {
        this.privileges = privileges;
    }

    public Integer getGroupId() {
        return groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public Integer getApplyToDept() {
        return applyToDept;
    }

    public void setApplyToDept(Integer applyToDept) {
        this.applyToDept = applyToDept;
    }

    public Integer getPid() {
        return pid;
    }

    public void setPid(Integer pid) {
        this.pid = pid;
    }

    public Integer getIsGrades() {
        return isGrades;
    }

    public void setIsGrades(Integer isGrades) {
        this.isGrades = isGrades;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof RoleDto) {
            RoleDto role = (RoleDto) obj;
            if (this.id.equals(role.getId()) && this.roleName.equals(role.getRoleName())) {
                result = true;
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        return id.hashCode();
    }
}