package com.ovopark.boot.business.base.entity.face;

import com.baomidou.mybatisplus.annotation.TableName;
import com.ovopark.boot.core.entity.group.BaseGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;

import javax.validation.constraints.NotNull;

import java.io.Serializable;

/**
 * <p>
 * 
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2020-01-06
 */
@TableName("is_face_api_callback")
public class FaceApiCallback implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    @NotNull(message = "分组编号不能为空",groups = { BaseGroup.Delete.class,BaseGroup.Update.class})
    private Integer id;

    private Integer enterpriseId;

    @NotNull(message = "分组编号不能为空",groups = { BaseGroup.Insert.class,BaseGroup.Update.class})
    private Integer depId;

    @NotNull(message = "下行回调地址不能为空",groups = { BaseGroup.Insert.class,BaseGroup.Update.class})
    private String callBackUrl;

    @NotNull(message = "设备mac不能为空",groups = { BaseGroup.Insert.class,BaseGroup.Update.class})
    private String deviceMac;

    private transient LocalDateTime createTime;

    private String version;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getEnterpriseId() {
        return enterpriseId;
    }

    public void setEnterpriseId(Integer enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public Integer getDepId() {
        return depId;
    }

    public void setDepId(Integer depId) {
        this.depId = depId;
    }

    public String getCallBackUrl() {
        return callBackUrl;
    }

    public void setCallBackUrl(String callBackUrl) {
        this.callBackUrl = callBackUrl;
    }

    public String getDeviceMac() {
        return deviceMac;
    }

    public void setDeviceMac(String deviceMac) {
        this.deviceMac = deviceMac;
    }

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public void setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
    }

    public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	@Override
    public String toString() {
        return "FaceApiCallback{" +
        "id=" + id +
        ", enterpriseId=" + enterpriseId +
        ", depId=" + depId +
        ", callBackUrl=" + callBackUrl +
        ", deviceMac=" + deviceMac +
        ", createTime=" + createTime +
        ", version=" + version +
        "}";
    }
}
