package com.ovopark.boot.business.base.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ovopark.boot.business.base.entity.Departments;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2019-07-08
 */
public interface DepartmentsService extends IService<Departments> {
	
	
	Departments getDepartmentById(Integer depId);
	
	List<Departments> getDepartmentsByIds(String depIds);
	
	List<Departments> getDepartmentsByEnterpriseId(Integer enterpriseId);
	
	Departments getDepartment(Integer enterpriseId,String shopId);
	
	boolean verifyOrganizations(Integer enterpriseId,Integer depId);
	
	
	List<Object> getDepartmentsIds(Integer enterpriseId);
	
	List<Departments> getDepartmentsByEnterpriseIds(List<Integer> enterpriseIds);
	
	List<Departments> getDepartmentsByIds(List<Integer> depIds);


	/**
	 * 获取用户有权限的门店
	 * @param userId
	 * @param groupId
	 * @param pageNum
	 * @param pageSize
	 * @return
	 */
    IPage<Departments> getUserDepartments(Integer userId, Integer groupId, Integer pageNum, Integer pageSize);
}
