package com.ovopark.boot.business.base.service;

import com.ovopark.boot.business.base.entity.EnterpriseGroups;

import java.util.List;

import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2019-07-08
 */
public interface EnterpriseGroupsService extends IService<EnterpriseGroups> {
	
	EnterpriseGroups getEnterpriseById(Integer enterpriseId);
	
	boolean verifySupplierOrgs(String supplierAccount, Integer enterpriseId);
	
	/**
	 * @Title: getIdsBySupplierId   
	 * @Description: TODO(根据代理商id查询企业id权限)   
	 * @param: @param supplierId
	 * @param: @return      
	 * @return: List<Integer>      
	 * @throws
	 */
	List<Integer> getIdsBySupplierId(Integer supplierId);
	/**
	 * 
	 * @Title: getEnterpriseGroupsBySupplierId   
	 * @Description: TODO(根据代理商id查询企业权限列表)   
	 * @param: @param supplierId
	 * @param: @return      
	 * @return: List<EnterpriseGroups>      
	 * @throws
	 */
	List<EnterpriseGroups> getEnterpriseGroupsBySupplierId(Integer supplierId);
}
