package com.ovopark.boot.business.base.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ovopark.boot.business.base.entity.UserDepartmentPrivilege;
import com.baomidou.mybatisplus.extension.service.IService;

import java.util.List;

/**
 * <p>
 * 门店权限表 服务类
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2020-05-06
 */
public interface UserDepartmentPrivilegeService extends IService<UserDepartmentPrivilege> {

    /**
     * 查询非管理员和root 拥有的门店
     * @param userId 用户id
     * @param groupId groupId
     * @param pageNumber 当前页
     * @param pageSize 每页记录数
     * @return IPage<UserDepartmentPrivilege>
     */
    IPage<UserDepartmentPrivilege> getUserDepartmentPrivilegeNotAdminAndSupperPage(Integer userId, Integer groupId, Integer pageNumber, Integer pageSize);

    /**
     * 查询非管理员和root 拥有的门店
     * @param userId 用户id
     * @param groupId groupId
     * @return List<UserDepartmentPrivilege>
     */
    List<UserDepartmentPrivilege> getUserDepartmentPrivilegeNotAdminAndSupper(Integer userId, Integer groupId);
}
