package com.ovopark.boot.business.base.service;

import com.ovopark.boot.business.base.entity.Users;

import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.ovopark.boot.business.base.entity.dto.UserDto;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2019-07-08
 */
public interface UsersService extends IService<Users> {
	/**
	 * @Title: getUserByToken   
	 * @Description: TODO(根据用户token获取用户)   
	 * @param: @param authenticator
	 * @param: @return      
	 * @return: Users      
	 * @throws
	 */
	Users getUserByToken(String authenticator);
	/**
	 * 
	 * @Title: getUserByUserId   
	 * @Description: TODO(根据用户id获取用户)   
	 * @param: @param userId
	 * @param: @return      
	 * @return: Users      
	 * @throws
	 */
	Users getUserByUserId(Integer userId);
	
	/**
	 * @Title: getUserByUserName   
	 * @Description: TODO(根据用户姓名查询用户)   
	 * @param: @param userName
	 * @param: @return      
	 * @return: Users      
	 * @throws
	 */
	Users getUserByUserName(String userName);
	/**
	 * 
	 * @Title: getUserList   
	 * @Description: TODO(根据企业id获取用户列表)   
	 * @param: @param enterpriseId
	 * @param: @return      
	 * @return: List<Users>      
	 * @throws
	 */
	List<Users> getUserList(Integer enterpriseId);
	
	
	IPage<Users> getUserListByPage(Integer enterpriseId,int pageNumber,int pageSize);
	
	Users login(String username,String password);

	/**
	 * @Title: getUserByToken
	 * @Description: TODO(根据用户token获取用户和权限)
	 * @param: @param authenticator
	 * @param: @return
	 * @return: Users
	 * @throws
	 */
	UserDto getUserAndRolesByToken(String authenticator);

	UserDto getUserAndRolesByUserId(Integer userId);

}
