package com.ovopark.boot.business.base.service.dubbo;



import com.ovopark.boot.core.annotation.OpenPlatformApi;
import com.ovopark.boot.core.em.GwType;
import com.ovopark.boot.core.em.GwVersion;
import com.ovopark.boot.core.plugin.activerecord.GG;

/**
 * 
 * @ClassName:  DepartmentsDubboService   
 * @Description:TODO(门店dubbo服务定义)   
 * @author: Remiel_Mercy 
 * @date:   2019年7月12日 下午7:22:13   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public interface DepartmentsDubboService {
	/**
	 * @Title: getDepartmentById   
	 * @Description: TODO(根据门店id查询门店)   
	 * @param: @param depId
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	@OpenPlatformApi(gwtype=GwType.OPEN,mt="open.business.base.department.getDepartmentById",version=GwVersion.v1, route="http://business.ovopark.com/api/business/base/department/v1/getDepartmentById")
	GG getDepartmentById(Integer depId);
	/**
	 * @Title: getDepartmentsByIds   
	 * @Description: TODO(根据门店id串查询门店集合)   
	 * @param: @param depIds
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	@OpenPlatformApi(gwtype=GwType.OPEN,mt="open.business.base.department.getDepartmentsByIds",version=GwVersion.v1, route="http://business.ovopark.com/api/business/base/department/v1/getDepartmentsByIds")
	GG getDepartmentsByIds(String depIds);
	/**
	 * @Title: getDepartmentsByEnterpriseId   
	 * @Description: TODO(根据企业id查询门店)   
	 * @param: @param enterpriseId
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	@OpenPlatformApi(gwtype=GwType.OPEN,mt="open.business.base.department.getDepartmentsByEnterpriseId",version=GwVersion.v1, route="http://business.ovopark.com/api/business/base/department/v1/getDepartmentsByEnterpriseId")
	GG getDepartmentsByEnterpriseId(Integer enterpriseId); 
	/**
	 * @Title: getDepartment   
	 * @Description: TODO(根据查询实体查询门店)   
	 * @param: @param department
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG getDepartment(Integer enterpriseId,String shopId);
	/**
	 * @Title: verifyOrganizations   
	 * @Description: TODO(验证depId是否在当前企业下)   
	 * @param: @param enterpriseId
	 * @param: @param depId
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG verifyOrganizations(Integer enterpriseId,Integer depId);
	
	/**
	 * @Title: getDepartmentsIds   
	 * @Description: TODO(根据企业Id查询所有的门店列表)   
	 * @param: @param enterpriseId
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG getDepartmentsIds(Integer enterpriseId);
}
