/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.business.pos.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DateUtil {
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static ThreadLocal<SimpleDateFormat> ThreadDateTime = new ThreadLocal();
    private static ThreadLocal<SimpleDateFormat> ThreadDate = new ThreadLocal();
    private static ThreadLocal<SimpleDateFormat> ThreadTime = new ThreadLocal();

    private static SimpleDateFormat DateTimeInstance() {
        SimpleDateFormat df = ThreadDateTime.get();
        if (df == null) {
            df = new SimpleDateFormat(DATETIME_FORMAT);
            ThreadDateTime.set(df);
        }
        return df;
    }

    private static SimpleDateFormat DateInstance() {
        SimpleDateFormat df = ThreadDate.get();
        if (df == null) {
            df = new SimpleDateFormat(DATE_FORMAT);
            ThreadDate.set(df);
        }
        return df;
    }

    private static SimpleDateFormat TimeInstance() {
        SimpleDateFormat df = ThreadTime.get();
        if (df == null) {
            df = new SimpleDateFormat(TIME_FORMAT);
            ThreadTime.set(df);
        }
        return df;
    }

    public static String currentDateTime() {
        return DateUtil.DateTimeInstance().format(new Date());
    }

    public static String dateTime(Date date) {
        return DateUtil.DateTimeInstance().format(date);
    }

    public static Date dateTime(String datestr) throws ParseException {
        return DateUtil.DateTimeInstance().parse(datestr);
    }

    public static String currentDate() {
        return DateUtil.DateInstance().format(new Date());
    }

    public static String date(Date date) {
        return DateUtil.DateInstance().format(date);
    }

    public static Date date(String dateStr) throws ParseException {
        return DateUtil.DateInstance().parse(dateStr);
    }

    public static String currentTime() {
        return DateUtil.TimeInstance().format(new Date());
    }

    public static String time(Date date) {
        return DateUtil.TimeInstance().format(date);
    }

    public static Date time(String dateStr) throws ParseException {
        return DateUtil.TimeInstance().parse(dateStr);
    }

    public static Date year(int year) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(new Date());
        Cal.add(1, year);
        return Cal.getTime();
    }

    public static Date year(Date date, int year) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(date);
        Cal.add(1, year);
        return Cal.getTime();
    }

    public static Date month(int month) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(new Date());
        Cal.add(2, month);
        return Cal.getTime();
    }

    public static Date month(Date date, int month) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(date);
        Cal.add(2, month);
        return Cal.getTime();
    }

    public static Date day(int day) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(new Date());
        Cal.add(6, day);
        return Cal.getTime();
    }

    public static Date day(Date date, int day) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(date);
        Cal.add(6, day);
        return Cal.getTime();
    }

    public static Date hour(float hour) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(new Date());
        Cal.add(12, (int)(hour * 60.0f));
        return Cal.getTime();
    }

    public static Date hour(Date date, float hour) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(date);
        Cal.add(12, (int)(hour * 60.0f));
        return Cal.getTime();
    }

    public static Date minute(int minute) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(new Date());
        Cal.add(12, minute);
        return Cal.getTime();
    }

    public static Date minute(Date date, int minute) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(date);
        Cal.add(12, minute);
        return Cal.getTime();
    }

    public static boolean isDate(String date) {
        try {
            DateUtil.DateTimeInstance().parse(date);
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static long subtract(Date date1, Date date2) {
        long cha = (date2.getTime() - date1.getTime()) / 1000L;
        return cha;
    }

    public static long subtract(String date1, String date2) {
        long rs = 0L;
        try {
            long cha;
            Date start = DateUtil.DateTimeInstance().parse(date1);
            Date end = DateUtil.DateTimeInstance().parse(date2);
            rs = cha = (end.getTime() - start.getTime()) / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static int subtractMinute(String date1, String date2) {
        int rs = 0;
        try {
            Date start = DateUtil.DateTimeInstance().parse(date1);
            Date end = DateUtil.DateTimeInstance().parse(date2);
            long cha = (end.getTime() - start.getTime()) / 1000L;
            rs = (int)cha / 60;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static int subtractMinute(Date date1, Date date2) {
        long cha = date2.getTime() - date1.getTime();
        return (int)cha / 60000;
    }

    public static int subtractHour(Date date1, Date date2) {
        long cha = (date2.getTime() - date1.getTime()) / 1000L;
        return (int)cha / 3600;
    }

    public static int subtractHour(String date1, String date2) {
        int rs = 0;
        try {
            Date start = DateUtil.DateTimeInstance().parse(date1);
            Date end = DateUtil.DateTimeInstance().parse(date2);
            long cha = (end.getTime() - start.getTime()) / 1000L;
            rs = (int)cha / 3600;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static int subtractDay(String date1, String date2) {
        int rs = 0;
        try {
            Date start = DateUtil.DateTimeInstance().parse(date1);
            Date end = DateUtil.DateTimeInstance().parse(date2);
            long sss = (end.getTime() - start.getTime()) / 1000L;
            rs = (int)sss / 86400;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static int subtractDay(Date date1, Date date2) {
        long cha = date2.getTime() - date1.getTime();
        return (int)cha / 86400000;
    }

    public static int subtractMonth(String date1, String date2) {
        int result;
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            c1.setTime(DateUtil.DateInstance().parse(date1));
            c2.setTime(DateUtil.DateInstance().parse(date2));
            int year1 = c1.get(1);
            int month1 = c1.get(2);
            int year2 = c2.get(1);
            int month2 = c2.get(2);
            result = year1 == year2 ? month2 - month1 : 12 * (year2 - year1) + month2 - month1;
        }
        catch (ParseException e) {
            e.printStackTrace();
            result = -1;
        }
        return result;
    }

    public static int subtractMonth(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        int year1 = c1.get(1);
        int month1 = c1.get(2);
        int year2 = c2.get(1);
        int month2 = c2.get(2);
        int result = year1 == year2 ? month2 - month1 : 12 * (year2 - year1) + month2 - month1;
        return result;
    }

    public static int subtractYear(String date1, String date2) {
        int result;
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        try {
            c1.setTime(DateUtil.DateInstance().parse(date1));
            c2.setTime(DateUtil.DateInstance().parse(date2));
            int year1 = c1.get(1);
            int year2 = c2.get(1);
            result = year2 - year1;
        }
        catch (ParseException e) {
            e.printStackTrace();
            result = -1;
        }
        return result;
    }

    public static int subtractYear(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        int year1 = c1.get(1);
        int year2 = c2.get(1);
        int result = year2 - year1;
        return result;
    }

    public static String subtractTime(String date1, String date2) {
        String result = "";
        try {
            Date start = DateUtil.DateTimeInstance().parse(date1);
            Date end = DateUtil.DateTimeInstance().parse(date2);
            long sss = (end.getTime() - start.getTime()) / 1000L;
            int hh = (int)sss / 3600;
            int mm = (int)(sss - (long)(hh * 60 * 60)) / 60;
            int ss = (int)(sss - (long)(hh * 60 * 60) - (long)(mm * 60));
            result = hh + ":" + mm + ":" + ss;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String subtractDate(String date1, String date2) {
        String result = "";
        try {
            Date start = DateUtil.DateTimeInstance().parse(date1);
            Date end = DateUtil.DateTimeInstance().parse(date2);
            long sss = (end.getTime() - start.getTime()) / 1000L;
            int dd = (int)sss / 86400;
            int hh = (int)(sss - (long)(dd * 60 * 60 * 24)) / 3600;
            int mm = (int)(sss - (long)(dd * 60 * 60 * 24) - (long)(hh * 60 * 60)) / 60;
            int ss = (int)(sss - (long)(dd * 60 * 60 * 24) - (long)(hh * 60 * 60) - (long)(mm * 60));
            result = dd + "-" + hh + ":" + mm + ":" + ss;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int subDay(Date startTime, Date endTime) {
        int days = 0;
        Calendar can1 = Calendar.getInstance();
        can1.setTime(startTime);
        Calendar can2 = Calendar.getInstance();
        can2.setTime(endTime);
        int year1 = can1.get(1);
        int year2 = can2.get(1);
        Calendar can = null;
        if (can1.before(can2)) {
            days -= can1.get(6);
            days += can2.get(6);
            can = can1;
        } else {
            days -= can2.get(6);
            days += can1.get(6);
            can = can2;
        }
        for (int i = 0; i < Math.abs(year2 - year1); ++i) {
            days += can.getActualMaximum(6);
            can.add(1, 1);
        }
        return days;
    }

    public static int subDay(String startTime, String endTime) {
        int days = 0;
        try {
            Date date1 = DateUtil.DateInstance().parse(DateUtil.DateInstance().format(DateUtil.DateTimeInstance().parse(startTime)));
            Date date2 = DateUtil.DateInstance().parse(DateUtil.DateInstance().format(DateUtil.DateTimeInstance().parse(endTime)));
            Calendar can1 = Calendar.getInstance();
            can1.setTime(date1);
            Calendar can2 = Calendar.getInstance();
            can2.setTime(date2);
            int year1 = can1.get(1);
            int year2 = can2.get(1);
            Calendar can = null;
            if (can1.before(can2)) {
                days -= can1.get(6);
                days += can2.get(6);
                can = can1;
            } else {
                days -= can2.get(6);
                days += can1.get(6);
                can = can2;
            }
            for (int i = 0; i < Math.abs(year2 - year1); ++i) {
                days += can.getActualMaximum(6);
                can.add(1, 1);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return days;
    }

    public static long subtimeBurst(String startDate, String endDate, String timeBurst) throws ParseException {
        Date start = DateUtil.DateTimeInstance().parse(startDate);
        Date end = DateUtil.DateTimeInstance().parse(endDate);
        return DateUtil.subtimeBurst(start, end, timeBurst);
    }

    public static long subtimeBurst(Date startDate, Date endDate, String timeBurst) throws ParseException {
        long second = 0L;
        Pattern p = Pattern.compile("^\\d{2}:\\d{2}-\\d{2}:\\d{2}");
        Matcher m = p.matcher(timeBurst);
        boolean falg = false;
        if (startDate.after(endDate)) {
            Date temp = startDate;
            startDate = endDate;
            endDate = temp;
            falg = true;
        }
        if (m.matches()) {
            String[] a = timeBurst.split("-");
            int day = DateUtil.subDay(startDate, endDate);
            if (day > 0) {
                long firstMintues = 0L;
                long lastMintues = 0L;
                long daySecond = 0L;
                String strDayStart = DateUtil.DateInstance().format(startDate) + " " + a[0] + ":00";
                String strDayEnd = DateUtil.DateInstance().format(startDate) + " " + a[1] + ":00";
                Date dayStart = DateUtil.DateTimeInstance().parse(strDayStart);
                Date dayEnd = DateUtil.DateTimeInstance().parse(strDayEnd);
                daySecond = DateUtil.subtract(dayStart, dayEnd);
                if ((startDate.after(dayStart) || startDate.equals(dayStart)) && startDate.before(dayEnd)) {
                    firstMintues = (dayEnd.getTime() - startDate.getTime()) / 1000L;
                } else if (startDate.before(dayStart)) {
                    firstMintues = (dayEnd.getTime() - dayStart.getTime()) / 1000L;
                }
                dayStart = DateUtil.DateTimeInstance().parse(DateUtil.DateInstance().format(endDate) + " " + a[0] + ":00");
                dayEnd = DateUtil.DateTimeInstance().parse(DateUtil.DateInstance().format(endDate) + " " + a[1] + ":00");
                if (endDate.after(dayStart) && (endDate.before(dayEnd) || endDate.equals(dayEnd))) {
                    lastMintues = (endDate.getTime() - dayStart.getTime()) / 1000L;
                } else if (endDate.after(dayEnd)) {
                    lastMintues = (dayEnd.getTime() - dayStart.getTime()) / 1000L;
                }
                second = firstMintues + lastMintues;
                second += (long)(day - 1) * daySecond;
            } else {
                String strDayStart = DateUtil.DateInstance().format(startDate) + " " + a[0] + ":00";
                String strDayEnd = DateUtil.DateInstance().format(startDate) + " " + a[1] + ":00";
                Date dayStart = DateUtil.DateTimeInstance().parse(strDayStart);
                Date dayEnd = DateUtil.DateTimeInstance().parse(strDayEnd);
                if ((startDate.after(dayStart) || startDate.equals(dayStart)) && startDate.before(dayEnd) && endDate.after(dayStart) && (endDate.before(dayEnd) || endDate.equals(dayEnd))) {
                    second = (endDate.getTime() - startDate.getTime()) / 1000L;
                } else {
                    if (startDate.before(dayStart)) {
                        second = endDate.before(dayEnd) ? (endDate.getTime() - dayStart.getTime()) / 1000L : (dayEnd.getTime() - dayStart.getTime()) / 1000L;
                    }
                    if (startDate.after(dayStart)) {
                        second = endDate.before(dayEnd) ? (endDate.getTime() - startDate.getTime()) / 1000L : (dayEnd.getTime() - startDate.getTime()) / 1000L;
                    }
                }
                if (startDate.before(dayStart) && endDate.before(dayStart) || startDate.after(dayEnd) && endDate.after(dayEnd)) {
                    second = 0L;
                }
            }
        } else {
            second = (endDate.getTime() - startDate.getTime()) / 1000L;
        }
        if (falg) {
            second = Long.parseLong("-" + second);
        }
        return second;
    }

    public static Date calculate(String date, int second, String timeBurst) {
        Date start = null;
        try {
            start = DateUtil.DateTimeInstance().parse(date);
            return DateUtil.calculate(start, second, timeBurst);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static Date calculate(Date date, int second, String timeBurst) {
        Calendar cal;
        block14: {
            Pattern p = Pattern.compile("^\\d{2}:\\d{2}-\\d{2}:\\d{2}");
            Matcher m = p.matcher(timeBurst);
            cal = Calendar.getInstance();
            if (m.matches()) {
                String[] a = timeBurst.split("-");
                try {
                    Date dayStart = DateUtil.DateTimeInstance().parse(DateUtil.DateInstance().format(date) + " " + a[0] + ":00");
                    Date dayEnd = DateUtil.DateTimeInstance().parse(DateUtil.DateInstance().format(date) + " " + a[1] + ":00");
                    int DaySecond = (int)DateUtil.subtract(dayStart, dayEnd);
                    int toDaySecond = (int)DateUtil.subtract(dayStart, dayEnd);
                    if (second >= 0) {
                        if ((date.after(dayStart) || date.equals(dayStart)) && (date.before(dayEnd) || date.equals(dayEnd))) {
                            cal.setTime(date);
                            toDaySecond = (int)DateUtil.subtract(date, dayEnd);
                        }
                        if (date.before(dayStart)) {
                            cal.setTime(dayStart);
                            toDaySecond = (int)DateUtil.subtract(dayStart, dayEnd);
                        }
                        if (date.after(dayEnd)) {
                            cal.setTime(DateUtil.day(dayStart, 1));
                            toDaySecond = 0;
                        }
                        if (second > toDaySecond) {
                            int day = (second - toDaySecond) / DaySecond;
                            int remainder = (second - toDaySecond) % DaySecond;
                            cal.setTime(DateUtil.day(dayStart, 1));
                            cal.add(6, day);
                            cal.add(13, remainder);
                        } else {
                            cal.add(13, second);
                        }
                        break block14;
                    }
                    if ((date.after(dayStart) || date.equals(dayStart)) && (date.before(dayEnd) || date.equals(dayEnd))) {
                        cal.setTime(date);
                        toDaySecond = (int)DateUtil.subtract(date, dayStart);
                    }
                    if (date.before(dayStart)) {
                        cal.setTime(DateUtil.day(dayEnd, -1));
                        toDaySecond = 0;
                    }
                    if (date.after(dayEnd)) {
                        cal.setTime(dayEnd);
                        toDaySecond = (int)DateUtil.subtract(dayStart, dayEnd);
                    }
                    if (Math.abs(second) > Math.abs(toDaySecond)) {
                        int day = (Math.abs(second) - Math.abs(toDaySecond)) / DaySecond;
                        int remainder = (Math.abs(second) - Math.abs(toDaySecond)) % DaySecond;
                        cal.setTime(DateUtil.day(dayEnd, -1));
                        cal.add(6, Integer.valueOf("-" + day));
                        cal.add(13, Integer.valueOf("-" + remainder));
                        break block14;
                    }
                    cal.add(13, second);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
                cal.setTime(date);
            }
        }
        return cal.getTime();
    }

    public static boolean between(String startTime, String endTime, Date date) throws ParseException {
        return DateUtil.between(DateUtil.dateTime(startTime), DateUtil.dateTime(endTime), date);
    }

    public static boolean between(Date startTime, Date endTime, Date date) {
        return date.after(startTime) && date.before(endTime);
    }

    public static void main(String[] args) throws ParseException {
        Date currentDate = new Date();
        System.out.println(DateUtil.date(currentDate));
        System.out.println(DateUtil.date(DateUtil.day(currentDate, -6)));
    }
}

