/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.business.pos.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DateUtils {
    public static String FORMAT_NO_SECNOD = "yyyy-MM-dd HH:mm";
    public static String FORMAT_SHORT = "yyyy-MM-dd";
    public static String FORMAT_TIME = "HH:mm:ss";
    public static String FORMAT_LONG = "yyyy-MM-dd HH:mm:ss";
    public static String FORMAT_LONG_SLASH = "yyyy/MM/dd HH:mm:ss";
    public static String FORMAT_FULL = "yyyy-MM-dd HH:mm:ss.S";
    public static String FORMAT_SHORT_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    public static String FORMAT_LONG_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2";
    public static String FORMAT_FULL_CN = "yyyy\u5e74MM\u6708dd\u65e5  HH\u65f6mm\u5206ss\u79d2SSS\u6beb\u79d2";
    public static String FORMAT_DATAV = "yyyy/MM/dd HH:mm:ss";
    public static final int ONE_DAY_TO_MS = 86400000;
    public static final int FORMAT_WEEK_CN = 1;
    public static final int FORMAT_WEEK = 0;

    public static String getDatePattern() {
        return FORMAT_LONG;
    }

    public static String getDatePattern(String strDate) {
        if (strDate == null) {
            return null;
        }
        if (strDate.length() == 10) {
            return FORMAT_SHORT;
        }
        if (strDate.length() == 19) {
            return FORMAT_LONG;
        }
        return FORMAT_LONG;
    }

    public static String getNow() {
        return DateUtils.format(new Date());
    }

    public static String getNow(String format) {
        return DateUtils.format(new Date(), format);
    }

    public static String format(Date date) {
        return DateUtils.format(date, DateUtils.getDatePattern());
    }

    public static String format(Date date, String pattern) {
        String returnValue = "";
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(pattern);
            returnValue = df.format(date);
        }
        return returnValue;
    }

    public static Date parse(String strDate) {
        return DateUtils.parse(strDate, DateUtils.getDatePattern(strDate));
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), 1);
        return DateUtils.getStartTimeOfDay(calendar.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.getActualMaximum(5));
        return DateUtils.getEndTimeOfDay(calendar.getTime());
    }

    public static Date parse(String strDate, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        try {
            return df.parse(strDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date addYear(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(1, n);
        return cal.getTime();
    }

    public static Date addMonth(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, n);
        return cal.getTime();
    }

    public static Date addDay(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, n);
        return cal.getTime();
    }

    public static Date addHour(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(10, n);
        return cal.getTime();
    }

    public static Date addMinute(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(12, n);
        return cal.getTime();
    }

    public static Date addSecond(Date date, int n) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(13, n);
        return cal.getTime();
    }

    public static String getTimeString() {
        SimpleDateFormat df = new SimpleDateFormat(FORMAT_FULL);
        Calendar calendar = Calendar.getInstance();
        return df.format(calendar.getTime());
    }

    public static String getYear(Date date) {
        return DateUtils.format(date).substring(0, 4);
    }

    public static int countDays(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static int countSecond(Date date1, Date date2) {
        int second = (int)((date2.getTime() - date1.getTime()) / 1000L);
        return second;
    }

    public static int countMinute(Date date1, Date date2) {
        int second = (int)((date2.getTime() - date1.getTime()) / 60000L);
        return second;
    }

    public static int countDays(String date) {
        return DateUtils.countDays(date, DateUtils.getDatePattern());
    }

    public static int countDays(String date, String format) {
        Date t = Calendar.getInstance().getTime();
        Calendar c = Calendar.getInstance();
        c.setTime(DateUtils.parse(date, format));
        Date t1 = c.getTime();
        return DateUtils.countDays(t1, t);
    }

    public static Date getStartTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getStartTimeOfDay(String startTime, String pattern) {
        if (startTime != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.parse(startTime, pattern));
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return cal.getTime();
        }
        return null;
    }

    public static String getStartTimeOfDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_LONG_SLASH);
        return sdf.format(cal.getTime());
    }

    public static Date getEndTimeOfDay(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getEndTimeOfDay(String endTime, String pattern) {
        if (endTime != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(DateUtils.parse(endTime, pattern));
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
            cal.set(14, 0);
            return cal.getTime();
        }
        return null;
    }

    public static String getEndTimeOfDay(Calendar cal) {
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_LONG_SLASH);
        return sdf.format(cal.getTime());
    }

    public static List<Date> getDateListUntilToday(Date startDate) {
        ArrayList<Date> result = new ArrayList<Date>();
        Date start = DateUtils.getStartTimeOfDay(startDate);
        long startTime = start.getTime();
        int days = DateUtils.countDays(start, new Date());
        for (int i = 0; i < days; ++i) {
            if (i > 0) {
                startTime += 86400000L;
            }
            result.add(new Date(startTime));
        }
        return result;
    }

    public static List<Date> findDates(Date dBegin, Date dEnd) {
        ArrayList<Date> lDate = new ArrayList<Date>();
        lDate.add(dBegin);
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(calBegin.getTime());
        }
        return lDate;
    }

    public static List<String> findDatesContainStartAndEnd(Date dBegin, Date dEnd, String format) {
        ArrayList<String> lDate = new ArrayList<String>();
        lDate.add(DateUtils.format(dBegin, format));
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(dBegin);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(dEnd);
        while (dEnd.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            lDate.add(DateUtils.format(calBegin.getTime(), format));
        }
        return lDate;
    }

    public static String getWeekOfDate(Date dt) {
        return DateUtils.getWeekOfDate(dt, 1);
    }

    public static Integer getWeekNumOfDate(Date dt) {
        int[] weekDays = new int[]{6, 0, 1, 2, 3, 4, 5};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        return weekDays[w];
    }

    public static String getWeekOfDate(Date dt, int type) {
        String[] weekDays = new String[]{"\u661f\u671f\u65e5", "\u661f\u671f\u4e00", "\u661f\u671f\u4e8c", "\u661f\u671f\u4e09", "\u661f\u671f\u56db", "\u661f\u671f\u4e94", "\u661f\u671f\u516d"};
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(7) - 1;
        if (w < 0) {
            w = 0;
        }
        if (type == 1) {
            return weekDays[w];
        }
        return w + "";
    }

    public static String getDayOfMonth(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        int w = cal.get(5);
        return w + "";
    }

    public static Date changeStr2StartDate(String time) {
        if (time == null) {
            return null;
        }
        return DateUtils.getStartTimeOfDay(DateUtils.changeStr2Date(time));
    }

    public static Date changeStr2EndDate(String time) {
        if (time == null) {
            return null;
        }
        return DateUtils.getEndTimeOfDay(DateUtils.changeStr2Date(time));
    }

    public static Date changeStr2Date(String time) {
        if (time == null) {
            return null;
        }
        int shortLen = FORMAT_SHORT.length();
        int longLen = FORMAT_LONG.length();
        int noSecondLen = FORMAT_NO_SECNOD.length();
        if (time.length() == shortLen) {
            return DateUtils.parse(time, FORMAT_SHORT);
        }
        if (time.length() == longLen) {
            return DateUtils.parse(time, FORMAT_LONG);
        }
        if (time.length() == noSecondLen) {
            return DateUtils.parse(time, FORMAT_NO_SECNOD);
        }
        if (time.length() == 13) {
            return new Date(Long.valueOf(time));
        }
        return null;
    }

    public static String getQuarter(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int month = cal.get(2);
        int year = cal.get(1);
        switch (month) {
            case 0: 
            case 1: 
            case 2: {
                return year + "Q1";
            }
            case 3: 
            case 4: 
            case 5: {
                return year + "Q2";
            }
            case 6: 
            case 7: 
            case 8: {
                return year + "Q3";
            }
            case 9: 
            case 10: 
            case 11: {
                return year + "Q4";
            }
        }
        return "";
    }

    public static int getWeekOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        return calendar.get(3);
    }

    public static String getDatePeriodByWeekOfYear(int year, int i) {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(2);
        cal.set(1, year);
        cal.set(3, i);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_SHORT);
        cal.set(7, cal.getFirstDayOfWeek());
        String beginDate = sdf.format(cal.getTime());
        cal.add(7, 6);
        String endDate = sdf.format(cal.getTime());
        return beginDate + "~" + endDate;
    }

    public static Date getYearBeginDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, 0, 1, 0, 0, 0);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_SHORT);
        String beginDate = sdf.format(cal.getTime());
        return DateUtils.parse(beginDate, FORMAT_SHORT);
    }

    public static Date getYearEndDate(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, 11, 31, 0, 0, 0);
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_SHORT);
        String beginDate = sdf.format(cal.getTime());
        return DateUtils.getEndTimeOfDay(DateUtils.parse(beginDate, FORMAT_SHORT));
    }

    public static void main(String[] args) {
        System.out.println(DateUtils.getLastDayOfMonth(new Date()));
        System.out.println(DateUtils.getFirstDayOfMonth(new Date()));
    }
}

