/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.business.pos.util;

import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReportUtil {
    public static String getShowTime(Date inputTime, String date, int timeType) {
        String output = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String inputTimeStr = null;
        if (inputTime != null) {
            inputTimeStr = sdf.format(inputTime);
        }
        switch (timeType) {
            case 1: {
                if ("00:00".equals(date)) {
                    output = "24:00";
                }
                output = inputTimeStr.substring(11, 16);
                break;
            }
            case 2: {
                output = inputTimeStr.substring(0, 10);
                break;
            }
            case 3: {
                output = "\u7b2c" + date + "\u5468";
                break;
            }
            case 4: {
                output = date + "\u6708";
                break;
            }
            case 5: {
                output = "\u7b2c" + date + "\u5b63\u5ea6";
                break;
            }
            case 6: {
                output = date;
                break;
            }
            case 7: {
                output = date;
                break;
            }
            default: {
                output = inputTimeStr.substring(11, 16);
            }
        }
        return output;
    }

    public static String getShowTimeStr(String dateStr, int timeType) {
        String output = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        switch (timeType) {
            case 0: {
                output = dateStr.substring(11, 16);
                break;
            }
            case 1: {
                output = dateStr.substring(11, 16);
                if (!"00:00".equals(output)) break;
                output = "24:00";
                break;
            }
            case 2: {
                output = dateStr.substring(0, 10);
                break;
            }
            case 3: {
                output = "\u7b2c" + cal.get(3) + "\u5468";
                break;
            }
            case 4: {
                int month = cal.get(2) + 1;
                String monthStr = month < 10 ? "0" + month : "" + month;
                output = monthStr + "\u6708";
                break;
            }
            case 5: {
                output = "\u7b2c" + (cal.get(2) / 3 + 1) + "\u5b63\u5ea6";
                break;
            }
            case 6: {
                output = cal.get(1) + "";
                break;
            }
            default: {
                output = dateStr.substring(11, 16);
                if (!"00:00".equals(output)) break;
                output = "24:00";
            }
        }
        return output;
    }

    public static List<String> getBetweenDates(String minDate, String maxDate) throws ParseException {
        ArrayList<String> listDate = new ArrayList<String>();
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = df.parse(minDate);
        startCalendar.setTime(startDate);
        Date endDate = df.parse(maxDate);
        endCalendar.setTime(endDate);
        listDate.add(df.format(startCalendar.getTime()));
        while (true) {
            startCalendar.add(5, 1);
            if (startCalendar.getTimeInMillis() > endCalendar.getTimeInMillis()) break;
            listDate.add(df.format(startCalendar.getTime()));
        }
        return listDate;
    }

    public static void completeDate(List<Map<String, Object>> map, List<String> categories) {
        for (String date : categories) {
            boolean isTrue = true;
            for (Map<String, Object> m : map) {
                if (m.get("time") == null || !m.get("time").toString().equals(date)) continue;
                isTrue = false;
                break;
            }
            if (!isTrue) continue;
            HashMap<String, Object> ma = new HashMap<String, Object>();
            ma.put("time", date);
            ma.put("total", 0);
            map.add(ma);
        }
    }

    public static void augment(List<String> categories, String stime, String etime, Integer timeType) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(stime);
            endDate = sdf.parse(etime);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(startDate);
        boolean isFirst = true;
        while (!cal.getTime().after(endDate)) {
            String dateStr = sdf.format(cal.getTime());
            String timeStr = ReportUtil.getShowTimeStr(dateStr, timeType);
            if (timeType == 1) {
                if (!isFirst) {
                    if (!categories.contains(timeStr)) {
                        categories.add(timeStr);
                    }
                } else {
                    isFirst = false;
                }
            } else if (!categories.contains(timeStr)) {
                categories.add(timeStr);
            }
            switch (timeType) {
                case 0: {
                    cal.add(12, 1);
                    break;
                }
                case 1: {
                    cal.add(10, 1);
                    break;
                }
                case 2: {
                    cal.add(5, 1);
                    break;
                }
                case 3: {
                    cal.add(5, 7);
                    break;
                }
                case 4: {
                    cal.add(2, 1);
                    break;
                }
                case 5: {
                    cal.add(2, 3);
                    break;
                }
                case 6: {
                    cal.add(1, 1);
                }
            }
        }
    }

    public static void formatDate(List<Map<String, Object>> map, Integer timeType, String stime, String etime) {
        try {
            if (timeType == 3 || timeType == 2) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (Map<String, Object> m : map) {
                    if (null != m.get("createTime")) {
                        if (m.get("createTime") instanceof Timestamp) {
                            m.put("createTime", (Timestamp)m.get("createTime"));
                        } else {
                            m.put("time", m.get("createTime").toString());
                        }
                        if (m.get("time") != null) {
                            m.put("time", ReportUtil.getShowTime(null, m.get("time").toString(), timeType));
                        } else {
                            m.put("time", ReportUtil.getShowTime(sdf.parse(m.get("createTime").toString()), null, timeType));
                        }
                    } else {
                        m.put("time", ReportUtil.getShowTimeStr(stime, timeType));
                    }
                    if (m.get("total") != null) {
                        m.put("total", Integer.valueOf(m.get("total").toString()));
                    }
                    if (m.get("inCount1") != null) {
                        m.put("inCount1", Integer.valueOf(m.get("inCount1").toString()));
                    }
                    if (m.get("outCount1") == null) continue;
                    m.put("outCount1", Integer.valueOf(m.get("outCount1").toString()));
                }
            } else if (timeType == 4 || timeType == 5 || timeType == 6) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (Map<String, Object> m : map) {
                    if (null != m.get("createTime")) {
                        if (m.get("createTime") instanceof Timestamp) {
                            m.put("createTime", (Timestamp)m.get("createTime"));
                        } else {
                            m.put("time", m.get("createTime").toString());
                        }
                        if (timeType == 4) {
                            Integer month = Integer.parseInt(m.get("time").toString(), 10);
                            m.put("time", month < 10 ? "0" + month : "" + month);
                        }
                        m.put("time", ReportUtil.getShowTime(null, m.get("time").toString(), timeType));
                    } else {
                        m.put("time", ReportUtil.getShowTimeStr(stime, timeType));
                    }
                    if (m.get("total") != null) {
                        m.put("total", Integer.valueOf(m.get("total").toString()));
                    }
                    if (m.get("inCount1") != null) {
                        m.put("inCount1", Integer.valueOf(m.get("inCount1").toString()));
                    }
                    if (m.get("outCount1") == null) continue;
                    m.put("outCount1", Integer.valueOf(m.get("outCount1").toString()));
                }
            } else if (timeType == 1) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                for (Map<String, Object> m : map) {
                    if (null != m.get("createTime").toString()) {
                        m.put("createTime", (Timestamp)m.get("createTime"));
                        m.put("time", ReportUtil.getShowTime(sdf.parse(m.get("createTime").toString()), m.get("createTime").toString(), timeType));
                    } else {
                        m.put("time", ReportUtil.getShowTimeStr(stime, 1));
                    }
                    if (m.get("total") != null) {
                        m.put("total", Integer.valueOf(m.get("total").toString()));
                    }
                    if (m.get("workerNum") != null) {
                        m.put("workerNum", Integer.valueOf(m.get("workerNum").toString()));
                    }
                    if (m.get("inCount1") != null) {
                        m.put("inCount1", Integer.valueOf(m.get("inCount1").toString()));
                    }
                    if (m.get("outCount1") == null) continue;
                    m.put("outCount1", Integer.valueOf(m.get("outCount1").toString()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

