package com.ovopark.boot.business.oa.code;

import com.ovopark.boot.core.code.AbstractReturnCode;
/**
 * 
 * @ClassName:  OaApiReturnCode   
 * @Description:TODO(OA系统编码,oa系统编号为S202，即返回码区间为202000~202999)   
 * @author: Remiel_Mercy 
 * @date:   2019年3月4日 下午5:03:32   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class OaApiReturnCode extends AbstractReturnCode{
	public OaApiReturnCode(String desc, String name, int code) {
		super(desc, name, code);
	}

	private static final long serialVersionUID = 1L;

	// api服务异常
	public static final int API_SYSTEM_ERROR_CODE = 202999;
	public final static AbstractReturnCode API_SYSTEM_ERROR = new OaApiReturnCode("api服务未知异常", "API_SYSTEM_ERROR",
			API_SYSTEM_ERROR_CODE);
	
	// 参数异常
	public static final int SIGN_PARAM_ERROR_CODE = 202666;
	public final static AbstractReturnCode SIGN_PARAM_ERROR = new OaApiReturnCode("参数异常", "SIGN_PARAM_ERROR",
			SIGN_PARAM_ERROR_CODE);
	
	//名称重复
	public static final int NAME_EXIST_CODE = 202667;
	public final static AbstractReturnCode NAME_EXIST = new OaApiReturnCode("名字已存在", "NAME_EXIST",
			NAME_EXIST_CODE);
	
	//不允许删除
	public static final int CANNOT_DELETE_CODE = 202667;
	public final static AbstractReturnCode CANNOT_DELETE = new OaApiReturnCode("无法删除", "CANNOT_DELETE",
			CANNOT_DELETE_CODE);
}
