package com.ovopark.boot.business.oa.service;

import com.ovopark.boot.business.oa.entity.Sign;
import com.ovopark.boot.business.oa.entity.SignInfo;

import java.util.Date;
import java.util.List;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2019-03-04
 */
public interface SignService extends IService<Sign> {
	/**
	 * 
	 * @param authenticator
	 * @param pageNumber
	 * @param pageSize
	 * @return
	 */
	IPage<Sign> getUserSignListByPage(String authenticator, int pageNumber, int pageSize);

	/**
	 * 保存打卡
	 * @param sign
	 * @param url
	 * @return 
	 */
	Integer saveSignIn(Sign sign, String url);

	/**
	 * 根据企业id和工号查询用户
	 * @param depId
	 * @param employeeNumber
	 * @return
	 */
	Integer findUserByEnterpriseIdAndEmployeeNumber(Integer depId, String employeeNumber);

	/**
	 * 查询打卡记录
	 * @param pageNumber
	 * @param pageSize
	 * @param enterpriseId
	 * @param depId
	 * @param userId
	 * @param startTime
	 * @param endTime
	 * @return
	 */
	List<SignInfo> getSignsByEnterpriseIdOpen(Integer enterpriseId, Integer depId, Integer userId,
			Date startTime, Date endTime);

	
}
