package com.ovopark.boot.business.oa.service;

import com.ovopark.boot.business.oa.entity.Sign;
import com.ovopark.boot.business.oa.entity.TrainingQuestionnaire;
import com.ovopark.boot.business.oa.entity.TrainingQuestionnaireRule;
import com.ovopark.boot.business.oa.entity.dto.TrainingQuestionnaireDto;
import com.ovopark.boot.business.oa.entity.dto.TrainingQuestionnaireRuleDto;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author Remiel_Mercy
 * @since 2019-03-04
 */
public interface TrainingService extends IService<Sign> {

	TrainingQuestionnaireRule getTrainingQuestionnaireRule(String authenticator);

	TrainingQuestionnaireDto getTrainingQuestionnaireDto(String authenticator, Integer trainingQuestionnaireId);

	Integer deleteTrainingQuestionnaireById(Integer id);

	IPage<TrainingQuestionnaire> getTrainingQuestionnaireByPage(String authenticator, int pageNumber, int pageSize,
			String name);

	Integer saveTrainingQuestionnaire(TrainingQuestionnaireDto trainingQuestionnaireDto,String authenticator);

	Integer saveTrainingQuestionnaireuUser(TrainingQuestionnaireDto trainingQuestionnaireDto, String authenticator);

	Integer saveTrainingQuestionnaireRule(TrainingQuestionnaireRuleDto trainingQuestionnaireRule,String authenticator);
	
	IPage<LinkedHashMap<String, Object>> getQuestionnaireResult(String userIds, Integer id, String name, Integer type,
			Date startTime, Date endTime, Integer pageSize, Integer pageNumber);

	TrainingQuestionnaireRuleDto getTrainingQuestionnaireRuleDto(String authenticator);

	boolean nameIsExist(Integer id, String title,String authenticator);

	boolean questionnaireIsExist(Integer id);

	boolean questionnaireIsUse(Integer id);

	void updateData();
}
