/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.config;

import com.ovopark.boot.business.push.code.PushApiReturnCode;
import com.ovopark.boot.core.code.AbstractReturnCode;
import com.ovopark.boot.core.code.CommonApiReturnCode;
import com.ovopark.boot.core.code.support.ApiCodeResult;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataAccessException;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${systemid}")
    private int systemid;
    static int index = 3;

    @ExceptionHandler(value={Exception.class})
    public Object handleBadRequest(Exception e) {
        BindingResult bindingResult;
        if (e instanceof DataAccessException) {
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            AbstractReturnCode Abcode = CommonApiReturnCode.API_SERVICE_ERROR;
            return ApiCodeResult.error((AbstractReturnCode)Abcode);
        }
        if (e instanceof BindException && null != (bindingResult = ((BindException)e).getBindingResult()) && bindingResult.hasErrors()) {
            ArrayList jsonList = new ArrayList();
            bindingResult.getFieldErrors().stream().forEach(fieldError -> {
                HashMap<String, String> jsonObject = new HashMap<String, String>(2);
                jsonObject.put("field", fieldError.getField());
                jsonObject.put("warning", fieldError.getDefaultMessage());
                jsonList.add(jsonObject);
            });
            AbstractReturnCode Abcode = CommonApiReturnCode.PARAMETER_VALIDATE_ERROR;
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            return ApiCodeResult.error((AbstractReturnCode)Abcode, jsonList);
        }
        if (e instanceof MissingServletRequestParameterException) {
            AbstractReturnCode Abcode = CommonApiReturnCode.PARAMETER_VALIDATE_ERROR;
            ArrayList jsonList = new ArrayList();
            HashMap<String, String> jsonObject = new HashMap<String, String>(2);
            jsonObject.put("field", ((MissingServletRequestParameterException)e).getParameterName());
            jsonObject.put("warning", e.getMessage());
            jsonList.add(jsonObject);
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            return ApiCodeResult.error((AbstractReturnCode)Abcode, jsonList);
        }
        if (e instanceof MethodArgumentNotValidException && null != (bindingResult = ((MethodArgumentNotValidException)e).getBindingResult()) && bindingResult.hasErrors()) {
            ArrayList jsonList = new ArrayList();
            bindingResult.getFieldErrors().stream().forEach(fieldError -> {
                HashMap<String, String> jsonObject = new HashMap<String, String>(2);
                jsonObject.put("field", fieldError.getField());
                jsonObject.put("warning", fieldError.getDefaultMessage());
                jsonList.add(jsonObject);
            });
            AbstractReturnCode Abcode = CommonApiReturnCode.PARAMETER_VALIDATE_ERROR;
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            return ApiCodeResult.error((AbstractReturnCode)Abcode, jsonList);
        }
        logger.error("Error: handleBadRequest StackTrace : {}", (Throwable)e);
        return ApiCodeResult.error((AbstractReturnCode)PushApiReturnCode.API_SYSTEM_ERROR);
    }
}

