package com.ovopark.boot.business.quartz.code;

import com.ovopark.boot.core.code.AbstractReturnCode;

/**
 * 
 * @ClassName: QuartzReturnCode
 * @Description:TODO(Base系统编码,base系统编号为S207，即返回码区间为207000~207999)
 * @author: Remiel_Mercy
 * @date: 2019年3月4日 下午5:03:32
 * 
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class QuartzReturnCode extends AbstractReturnCode {
	public QuartzReturnCode(String desc, String name, int code) {
		super(desc, name, code);
	}

	private static final long serialVersionUID = 1L;
	// 任务名称不能相同
	public static final int TASK_NAME_CANNOT_BE_THE_SAME_CODE = 207001;
	public final static AbstractReturnCode TASK_NAME_CANNOT_BE_THE_SAME = new QuartzReturnCode("同一收银台下任务名称不能相同", "TASK_NAME_CANNOT_BE_THE_SAME",
			TASK_NAME_CANNOT_BE_THE_SAME_CODE);

	// 任务已过期
	public static final int TASK_IS_EXPIRED_CODE = 207002;
	public final static AbstractReturnCode TASK_IS_EXPIRED = new QuartzReturnCode("任务已过期", "TASK_IS_EXPIRED",
			TASK_IS_EXPIRED_CODE);

	// 任务不存在
	public static final int TASK_IS_NULL_CODE = 207003;
	public final static AbstractReturnCode TASK_IS_NULL= new QuartzReturnCode("任务不存在", "TASK_IS_NULL",
			TASK_IS_NULL_CODE);


	//场景不存在
	public static final int SCENE_IS_NULL_CODE = 207004;
	public final static AbstractReturnCode SCENE_IS_NULL = new QuartzReturnCode("场景不存在", "SCENE_IS_NULL",
			SCENE_IS_NULL_CODE);

	//authenticator无效
	public static final int AUTHENTICATOR_IS_INVALID_CODE = 207005;
	public final static AbstractReturnCode AUTHENTICATOR_IS_INVALID = new QuartzReturnCode("无效的authenticator", "AUTHENTICATOR_IS_INVALID",
			AUTHENTICATOR_IS_INVALID_CODE);

	// api服务异常
	public static final int API_SYSTEM_ERROR_CODE = 207999;
	public final static AbstractReturnCode API_SYSTEM_ERROR = new QuartzReturnCode("api服务未知异常", "API_SYSTEM_ERROR",
			API_SYSTEM_ERROR_CODE);
}
