package com.ovopark.boot.business.quartz.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;

/**
 * 任务信息详情
 * Created by wuwenjiong on 2019/9/11.
 */
public class CashierTaskDetail implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 门店id
     */
    private Long deptId;

    /**
     * 门店名称
     */
    private String deptName;

    /**
     * 收银台id
     */
    private Long sceneId;

    /**
     * 场景名称
     */
    private String sceneName;

    /**
     * 任务名称
     */
    private String taskName;

    /**
     * 时段（如11:00-12:00 14:00-15:00）
     */
    private String periodTime;

    /**
     * 开始时间（如2019-08-14）
     */
    private String startTime;

    /**
     * 结束时间（如2019-08-14）
     */
    private String endTime;

    /**
     * 日期类型（1：日常，2：周末，3：活动日，4：全部）
     */
    private Integer dayType;

    /**
     * 统计频次（分钟/次）
     */
    private Integer frequency;

    /**
     * 排队人数限制
     */
    private Integer numberLimit;

    /**
     * 时间限制（分钟，多个以逗号分隔）
     */
    private String timeLimit;

    /**
     * 订单限制
     */
    private Integer orderLimit;

    /**
     * 图片框选区域（多个区域用英文分号“;”分隔；同一个区域内的坐标用英文逗号“,”分隔，默认尾点和首点相连做闭合，如x1,y1,x2,y2,x3,y3...xn,yn）
     */
    private String pictureArea;

    /**
     * 任务状态（1：开启状态，2：关闭状态）
     */
    private Integer taskState;

    /**
     * 创建者id
     */
    private Long creatorId;

    /**
     * 创建时间
     */
    private String createTime;

    /**
     * 修改时间
     */
    private String updateTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public String getSceneName() {
        return sceneName;
    }

    public void setSceneName(String sceneName) {
        this.sceneName = sceneName;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getPeriodTime() {
        return periodTime;
    }

    public void setPeriodTime(String periodTime) {
        this.periodTime = periodTime;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getDayType() {
        return dayType;
    }

    public void setDayType(Integer dayType) {
        this.dayType = dayType;
    }

    public Integer getFrequency() {
        return frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public Integer getNumberLimit() {
        return numberLimit;
    }

    public void setNumberLimit(Integer numberLimit) {
        this.numberLimit = numberLimit;
    }

    public String getTimeLimit() {
        return timeLimit;
    }

    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Integer getOrderLimit() {
        return orderLimit;
    }

    public void setOrderLimit(Integer orderLimit) {
        this.orderLimit = orderLimit;
    }

    public String getPictureArea() {
        return pictureArea;
    }

    public void setPictureArea(String pictureArea) {
        this.pictureArea = pictureArea;
    }

    public Integer getTaskState() {
        return taskState;
    }

    public void setTaskState(Integer taskState) {
        this.taskState = taskState;
    }

    public Long getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }
}
