package com.ovopark.boot.business.quartz.entity.dto;


import com.ovopark.boot.business.quartz.group.BaseGroup;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.Range;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.io.Serializable;
import java.util.List;

/**
 * 收银任务信息
 * Created by wuwenjiong on 2019/8/17.
 */
public class CashierTaskDTO implements Serializable {

    private static final long serialVersionUID = 1L;

    /** 收银台id */
    @Valid
    @NotNull(message = "sceneId不能为空", groups = { BaseGroup.Insert.class})
    private Long sceneId;

    /** 任务名称 */
    @Valid
    @NotEmpty(message = "taskName不能为空", groups = { BaseGroup.Insert.class})
    @Length(min = 1, max = 255, message = "taskName长度有误（{min}-{max}）", groups = { BaseGroup.Insert.class})
    private String taskName;

    /** 时段（如11:00-12:00 14:00-15:00）*/
    @Valid
    @NotEmpty(message = "periodTime不能为空", groups = { BaseGroup.Insert.class})
    @Pattern(regexp = "[0-9]{1,2}:[0-9]{2}-[0-9]{1,2}:[0-9]{2}+(,[0-9]{1,2}:[0-9]{2}-[0-9]{1,2}:[0-9]{2}+)*", message = "periodTime格式有误，正确格式如10:00-11:00 多个以，分割", groups = { BaseGroup.Insert.class})
    private String periodTime;

    /** 开始时间（如2019-08-14）*/
    @Valid
    @NotEmpty(message = "startTime不能为空", groups = { BaseGroup.Insert.class})
    @Pattern(regexp = "[0-9]{4}-[0-9]{2}-[0-9]{2}", message = "startTime格式有误，正确格式如2019-08-14",groups = { BaseGroup.Insert.class})
    private String startTime;

    /** 结束时间（如2019-08-14）*/
    @Valid
    @NotEmpty(message = "endTime不能为空", groups = { BaseGroup.Insert.class})
    @Pattern(regexp = "[0-9]{4}-[0-9]{2}-[0-9]{2}", message = "endTime格式有误，正确格式如2019-08-14",groups = { BaseGroup.Insert.class})
    private String endTime;

    /** 日期类型（1：日常，2：周末，3：活动日）*/
    @Valid
    @NotNull(message = "dayType不能为空", groups = { BaseGroup.Insert.class})
    @Range(min = 1, max = 4, message = "dayType有误（1：日常，2：周末，3：活动日，4：全部）", groups = { BaseGroup.Insert.class})
    private Integer dayType;

    /** 统计频次（分钟/次）*/
    @Valid
    @NotNull(message = "frequency不能为空", groups = { BaseGroup.Insert.class})
    private Integer frequency;

    /** 排队人数限制 */
    @Valid
    @NotNull(message = "numberLimit不能为空", groups = { BaseGroup.Insert.class})
    private Integer numberLimit;

    /** 时间限制（分钟）*/
    @Valid
    @NotEmpty(message = "timeLimit不能为空", groups = { BaseGroup.Insert.class})
    @Pattern(regexp = "[0-9]+,[0-9]+", message = "timeLimit格式有误，正确格式如10,15",groups = { BaseGroup.Insert.class})
    private String timeLimit;

    /** 订单限制 */
    @Valid
    @NotNull(message = "orderLimit不能为空", groups = { BaseGroup.Insert.class})
    private Integer orderLimit;

    /** 图片框选区域（多个区域用英文分号“;”分隔；同一个区域内的坐标用英文逗号“,”分隔，默认尾点和首点相连做闭合，如x1,y1,x2,y2,x3,y3...xn,yn） */
    @Valid
    @NotEmpty(message = "pictureArea不能为空", groups = { BaseGroup.Insert.class})
    @Pattern(regexp = "[0-9]+(,[0-9]+)*", message = "pictureArea格式有误，多个区域用英文分号“;”分隔；同一个区域内的坐标用英文逗号“,”分隔，默认尾点和首点相连做闭合，如0,0,200,0,200,200,0,200", groups = { BaseGroup.Insert.class})
    private String pictureArea;

    /** 创建者id*/
    @Valid
    @NotNull(message = "creatorId不能为空", groups = { BaseGroup.Insert.class})
    private Long creatorId;

    public Long getSceneId() {
        return sceneId;
    }

    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    public String getTaskName() {
        return taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getPeriodTime() {
        return periodTime;
    }

    public void setPeriodTime(String periodTime) {
        this.periodTime = periodTime;
    }

    public String getStartTime() {
        return startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public Integer getDayType() {
        return dayType;
    }

    public void setDayType(Integer dayType) {
        this.dayType = dayType;
    }

    public Integer getFrequency() {
        return frequency;
    }

    public void setFrequency(Integer frequency) {
        this.frequency = frequency;
    }

    public Integer getNumberLimit() {
        return numberLimit;
    }

    public void setNumberLimit(Integer numberLimit) {
        this.numberLimit = numberLimit;
    }

    public String getTimeLimit() {
        return timeLimit;
    }

    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    public Integer getOrderLimit() {
        return orderLimit;
    }

    public void setOrderLimit(Integer orderLimit) {
        this.orderLimit = orderLimit;
    }

    public String getPictureArea() {
        return pictureArea;
    }

    public void setPictureArea(String pictureArea) {
        this.pictureArea = pictureArea;
    }

    public Long getCreatorId() {
        return creatorId;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }
}
