package com.ovopark.boot.business.quartz.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ovopark.boot.business.quartz.entity.CashierTaskRecord;
import com.ovopark.boot.business.quartz.entity.CashierTaskRecordInfo;

import java.util.List;

/**
 * 任务记录服务接口
 * Created by wuwenjiong on 2019/8/27.
 */
public interface CashierTaskRecordService extends IService<CashierTaskRecord> {

    /**
     * 创建任务记录
     * @param cashierTaskRecord
     * @return
     */
    CashierTaskRecord saveCashierTaskRecord(CashierTaskRecord cashierTaskRecord);


    /**
     * 查询任务记录列表
     * @param enterpriseId
     * @param deptId
     * @param pageBegin
     * @param pageSize
     * @return
     */
    List<CashierTaskRecordInfo> getCashierTaskRecordInfoList(Long enterpriseId,Long deptId,Integer pageBegin,Integer pageSize);


    /**
     * 查询任务记录列表总条数
     * @param enterpriseId
     * @param deptId
     * @return
     */
    Integer getCashierTaskRecordInfoListCount(Long enterpriseId,Long deptId);


}
