package com.ovopark.boot.business.quartz.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.ovopark.boot.business.quartz.entity.CashierTask;
import com.ovopark.boot.business.quartz.entity.CashierTaskDetail;
import com.ovopark.boot.business.quartz.entity.CashierTaskInfo;
import com.ovopark.boot.business.quartz.entity.DefaultConfig;

import java.util.List;


/**
 * 任务信息服务接口
 * Created by wuwenjiong on 2019/8/15.
 */
public interface CashierTaskService extends IService<CashierTask> {


    /**
     * 创建任务信息
     * @param cashierTask
     * @return
     */
    CashierTask saveCashierTask(CashierTask cashierTask);


    /**
     * 根据收银台场景与任务名称查询任务信息
     * @param sceneId
     * @param taskName
     * @return
     */
    CashierTask getBySceneIdAndTaskName(Long sceneId, String taskName);

    /**
     * 根据收银台场景与任务名称并排除指定id查询任务信息
     * @param sceneId
     * @param taskName
     * @param taskId
     * @return
     */
    CashierTask getBySceneIdAndTaskNameNotSelf(Long sceneId, String taskName, Long taskId);



    /**
     * 批量更新任务状态
     * @param taskIds
     * @param taskState
     * @param updateTime
     */
    void updateTaskStateByIds(List<Long> taskIds,Integer taskState,String updateTime);

    /**
     * 批量删除任务
     * @param taskIds
     */
    void deleteByIds(List<Long> taskIds);


    /**
     * 查询任务列表
     * @param enterpriseId
     * @param deptId
     * @param pageBegin
     * @param pageSize
     * @return
     */
    List<CashierTaskInfo> getCashierTaskInfoList(Long enterpriseId,Long deptId,Integer pageBegin,Integer pageSize);


    /**
     * 查询任务列表总条数
     * @param enterpriseId
     * @param deptId
     * @return
     */
    Integer getCashierTaskInfoListCount(Long enterpriseId,Long deptId);

    /**
     * 查询任务详情
     * @param taskId
     * @return
     */
    CashierTask getCashierTask(Long taskId);


    /**
     * 查询任务详情
     * @param taskId
     * @return
     */
    CashierTaskDetail getCashierTaskDetail(Long taskId);


    /**
     * 更新任务信息
     * @param cashierTask
     * @return
     */
    void updateCashierTask(CashierTask cashierTask);




}
