package com.ovopark.boot.business.quartz.service.dubbo;


import com.ovopark.boot.business.quartz.entity.CashierTask;
import com.ovopark.boot.business.quartz.entity.dto.CashierTaskDTO;
import com.ovopark.boot.business.quartz.entity.dto.CashierTaskUpdateDTO;
import com.ovopark.boot.core.plugin.activerecord.GG;
import org.quartz.SchedulerException;

import java.text.ParseException;

/**
 * 收银任务dubbo服务定义
 * Created by wuwenjiong on 2019/8/17.
 */
public interface CashierTaskDubboService {

    /**
     * 创建收银效率检测任务
     * @param cashierTaskDTO
     * @return
     */
    GG saveCashierTask(CashierTaskDTO cashierTaskDTO) throws ParseException, SchedulerException;

    /**
     * 暂停收银效率检测任务
     * @param taskIds
     * @return
     */
    GG pauseCashierTask(String taskIds) throws SchedulerException;

    /**
     * 恢复收银效率检测任务
     * @param taskIds
     * @return
     */
    GG resumeCashierTask(String taskIds) throws SchedulerException;

    /**
     * 删除收银效率检测任务
     * @param taskIds
     * @return
     * @throws SchedulerException
     */
    GG deleteCashierTask(String taskIds) throws SchedulerException;

    /**
     * 查询任务列表
     * @param enterpriseId
     * @param deptId
     * @param pageBegin
     * @param pageSize
     * @return
     */
    GG getCashierTaskInfoList(Long enterpriseId,Long deptId,Integer pageBegin,Integer pageSize);

    /**
     * 查询任务详情
     * @param taskId
     * @return
     */
    GG getCashierTask(Long taskId);

    /**
     * 更新任务信息
     * @param cashierTaskUpdateDTO
     * @return
     */
    GG updateCashierTask(CashierTaskUpdateDTO cashierTaskUpdateDTO) throws ParseException, SchedulerException;


    /**
     * 查询任务默认项
     * @param sceneId
     * @return
     */
    GG getDefaultConfig(Long sceneId);

    /**
     * 统计人流量
     * @param image
     * @param area
     * @param show
     * @return
     */
    GG getBodyNum(String image,String area,String show);
}
