package com.ovopark.boot.business.quartz.util;


import org.apache.http.HttpStatus;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 调用接口工具类
 * Created by wuwenjiong on 2018/5/3.
 */
public class HttpClientUtil {


    private final static Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

    /**
     * post请求调用接口提交表单
     * @param url
     * @param headParams
     * @param bodyParams
     * @return
     */
    public static String doPost(String url, Map<String,String> headParams, Map<String,String> bodyParams){
        CloseableHttpClient httpclient = HttpClientBuilder.create().build();
        CloseableHttpResponse response = null;
        String result = null;
        try {
            HttpPost httpPost = new HttpPost(url);
            ArrayList<BasicNameValuePair> list = new ArrayList<>();
            bodyParams.forEach((key, value) -> list.add(new BasicNameValuePair(key, value)));
            httpPost.setEntity(new UrlEncodedFormEntity(list,"UTF-8"));
            httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
            for(Map.Entry<String, String> entry : headParams.entrySet()) {
                httpPost.setHeader(entry.getKey(),entry.getValue());
            }
            logger.info("--->begin http post request,url:"+url);
            long startTime = System.currentTimeMillis();
            response = httpclient.execute(httpPost);
            long endTime = System.currentTimeMillis();
            logger.info("--->time consuming:"+(endTime-startTime)+"ms");
            if(response.getStatusLine().getStatusCode() == HttpStatus.SC_OK){
                result = EntityUtils.toString(response.getEntity(),Charset.forName("UTF-8"));// 返回json格式：
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            HttpClientUtils.closeQuietly(httpclient);
            HttpClientUtils.closeQuietly(response);
        }
        logger.info("--->end http post request,result:"+result);
        return result;

    }


    public static void main(String[] args) {
        String url = "http://www.ovopark.com/ajax/snapshotbyhand.action";
        Map<String,String> headParams = new HashMap<>();
        headParams.put("authenticator","1BABD44A649D8801F4A18428A7C798B02A3990AF35D16C1F930AEBF2FD1C67E3ED5B9CC36FCCC0AB2544AB18FE698385");
        Map<String,String> bodyParams = new HashMap<>();
        bodyParams.put("cp.deviceId","1655317");
        String result = HttpClientUtil.doPost(url, headParams, bodyParams);
        System.out.println(result);
    }

}
