package com.ovopark.boot.business.quartz.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import com.alibaba.fastjson.parser.Feature;
import org.apache.dubbo.common.utils.StringUtils;

import java.util.ArrayList;
import java.util.List;


/**
 * json解析工具类
 * Created by wuwenjiong on 2019/6/25.
 */
public class JsonParseUtil {

    /**
     * 通过key路径取对应的value值
     * @param jsonStr
     * @param jsonPath
     * @return
     */
    public static String getSingleValue(String jsonStr, String jsonPath){
        //解析时增加参数不调整顺序
        JSONObject jsonObject = JSON.parseObject(jsonStr, Feature.OrderedField);

        try {
            Object eval = JSONPath.eval(jsonObject, jsonPath);
            return eval.toString();
        } catch (NullPointerException e) {
            return "";
        }
    }


    /**
     * 通过key路径取对应的value数组
     * @param jsonStr
     * @param jsonPath
     * @return
     */
    public static List<String> getValue(String jsonStr, String jsonPath) {
        //解析时增加参数不调整顺序
        JSONObject jsonObject = JSON.parseObject(jsonStr, Feature.OrderedField);
        Object eval = JSONPath.eval(jsonObject, jsonPath);
        List<String> evalList = (List<String>) eval;
        if (evalList == null) {
            return new ArrayList<String>();
        }
        return evalList;

    }



    /**
     * 判断字符串是否可以转化为json对象
     * @param content
     * @return
     */
    public static boolean isJsonObject(String content) {
        // 此处应该注意，不要使用StringUtils.isEmpty(),因为当content为"  "空格字符串时，JSONObject.parseObject可以解析成功，
        // 实际上，这是没有什么意义的。所以content应该是非空白字符串且不为空，判断是否是JSON数组也是相同的情况。
        if(StringUtils.isBlank(content))
            return false;
        try {
            JSONObject jsonStr = JSONObject.parseObject(content);
            return true;
        } catch (Exception e) {
            return false;
        }
    }



    /**
     * 判断字符串是否可以转化为JSON数组
     * @param content
     * @return
     */
    public static boolean isJsonArray(String content) {
        if(StringUtils.isBlank(content))
            return false;
        StringUtils.isEmpty(content);
        try {
            JSONArray jsonStr = JSONArray.parseArray(content);
            return true;
        } catch (Exception e) {
            return false;
        }
    }




}
