package com.ovopark.boot.edas.ai.face.service.dubbo;

import com.ovopark.boot.core.plugin.activerecord.GG;

/**
 * @ClassName:  BodyAnalysisService   
 * @Description:TODO(人体识别dubbo服务定义)   
 * @author: Remiel_Mercy 
 * @date:   2019年7月19日 下午3:25:53   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public interface BodyAnalysisService {
	/**
	 * 
	 * @Title: bodyAttr   
	 * @Description: TODO(人体检测和属性识别)   
	 * @param: @param image 图像数据，base64编码后进行urlencode，要求base64编码和urlencode后大小不超过4M。图片的base64编码是不包含图片头的，如(data:image/jpg;base64,)，支持图片格式：jpg、bmp、png，最短边至少50px，最长边最大4096px
	 * @param: @param type
	 * 1）可选值说明：
		gender-性别，
		age-年龄阶段，
		lower_wear-下身服饰，
		upper_wear-上身服饰，
		headwear-是否戴帽子，
		glasses-是否戴眼镜，
		upper_color-上身服饰颜色，
		lower_color-下身服饰颜色，
		cellphone-是否使用手机，
		upper_wear_fg-上身服饰细分类，
		upper_wear_texture-上身服饰纹理，
		orientation-身体朝向，
		umbrella-是否撑伞；
		bag-背包,
		smoke-是否吸烟,
		vehicle-交通工具,
		carrying_item-是否有手提物,
		upper_cut-上方截断,
		lower_cut-下方截断,
		occlusion-遮挡,
		is_human-是否是正常人体
		2）type 参数值可以是可选值的组合，用逗号分隔；如果无此参数默认输出全部21个属性
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG bodyAttr(String image,String type);



	/**
	 *
	 * @Title: bodyNum
	 * @Description: TODO(识别和统计图像当中的人体个数)
	 * @param: @param image 图像数据，base64编码后进行urlencode，要求base64编码和urlencode后大小不超过4M。图片的base64编码是不包含图片头的，如(data:image/jpg;base64,)，支持图片格式：jpg、bmp、png，最短边至少50px，最长边最大4096px
	 * @param: @param area  特定框选区域坐标，支持多个多边形区域，最多支持10个区域，如输入超过10个区域，截取前10个区域进行识别。
	 *                       此参数为空或无此参数、或area参数设置错误时，默认识别整个图片的人数 。
	 *                       area参数设置错误的示例：某个坐标超过原图大小，x、y坐标未成对出现等；注意：设置了多个区域时，任意一个坐标设置错误，则认为area参数错误、失效。
	 *                       area参数设置格式：
	 *                       1）多个区域用英文分号“;”分隔；
	 *                       2）同一个区域内的坐标用英文逗号“,”分隔，默认尾点和首点相连做闭合。
	 *                       示例：
	 *                       1）单个多边形区域：x1,y1,x2,y2,x3,y3...xn,yn
	 *                       2）多个多边形区域：xa1,ya1,xa2,ya2,xa3,ya3...xan,yan;xb1,yb1,xb2,yb2,xb3,yb3...xbn,ybn;...
	 * @param: @param show  是否输出渲染的图片，默认不返回，选true时返回渲染后的图片(base64)，其它无效值或为空则默认false
	 * @param: @return
	 * @return: GG
	 * @throws
	 */
	GG bodyNum(String image, String area, String show);
	
}
