package com.ovopark.boot.edas.ai.image.code;

import com.ovopark.boot.core.code.AbstractReturnCode;
/**
 * 
 * @ClassName:  AiImageReturnCode   
 * @Description:TODO(图像识别返回码基类)   
 * @author: Remiel_Mercy 
 * @date:   2019年1月17日 上午10:29:28   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public class AiImageReturnCode extends AbstractReturnCode{
	public AiImageReturnCode(String desc, String name, int code) {
		super(desc, name, code);
	}

	private static final long serialVersionUID = 1L;
	// 服务请求超时
	public static final int SERVICE_TIMEOUT_CODE = 403066;
	public final static AbstractReturnCode SERVICE_TIMEOUT = new AiImageReturnCode("服务请求超时", "SERVICE_TIMEOUT",
			SERVICE_TIMEOUT_CODE);
	// token格式有误
	public static final int TOKEN_FORMAT_ERROR_CODE = 403096;
	public final static AbstractReturnCode TOKEN_FORMAT_ERROR = new AiImageReturnCode("token格式有误", "TOKEN_FORMAT_ERROR",
			TOKEN_FORMAT_ERROR_CODE);
	
	// token不能为空
	public static final int TOKEN_NOT_NULL_CODE = 403098;
	public final static AbstractReturnCode TOKEN_NOT_NULL = new AiImageReturnCode("token不能为空", "TOKEN_NOT_NULL",
			TOKEN_NOT_NULL_CODE);
	//json解析异常
	public static final int JSON_EXCEPTION_CODE = 403101;
	public final static AbstractReturnCode JSON_EXCEPTION = new AiImageReturnCode("json解析异常", "JSON_EXCEPTION",
			JSON_EXCEPTION_CODE);
	
	// api服务异常
	public static final int API_SYSTEM_ERROR_CODE = 403999;
	public final static AbstractReturnCode API_SYSTEM_ERROR = new AiImageReturnCode("api服务未知异常", "API_SYSTEM_ERROR",
			API_SYSTEM_ERROR_CODE);
}
