package com.ovopark.boot.edas.ai.image.service.baidu;

import org.json.JSONObject;

/**
 * 
 * @ClassName:  BaiduImageService   
 * @Description:TODO(百度图像识别接口)   
 * @author: Remiel_Mercy 
 * @date:   2019年1月17日 上午10:49:25   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public interface BaiduImageService {
	
	/**
	 * @Title: advancedGeneral   
	 * @Description: TODO（通用物体和场景识别高级版)   
	 * @param: @param image Base64编码字符串，以图片文件形式请求时必填。(支持图片格式：jpg，bmp，png，jpeg)，图片大小不超过4M。最短边至少15px，最长边最大4096px。注意：图片需要base64编码、去掉编码头后再进行urlencode
	 * @param: @param baike_num 返回百科信息的结果数，默认不返回
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 * 该请求用于通用物体及场景识别，即对于输入的一张图片（可正常解码，且长宽比适宜），输出图片中的多个物体及场景标签。
	 */
	JSONObject advancedGeneral(String image,Integer baike_num);
	
	/**
	 * 
	 * @Title: objectDetect   
	 * @Description: TODO()   
	 * @param: @param image Base64编码字符串，以图片文件形式请求时必填。(支持图片格式：jpg，bmp，png，jpeg)，图片大小不超过4M。最短边至少15px，最长边最大4096px。注意：图片需要base64编码、去掉编码头后再进行urlencode
	 * @param: @param baike_num 返回百科信息的结果数，默认不返回
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject objectDetect(String image,Integer baike_num);
	/**
	 * 
	 * @Title: dish   
	 * @Description: TODO(该请求用于菜品识别。即对于输入的一张图片（可正常解码，且长宽比适宜），输出图片的菜品名称、卡路里信息、置信度)   
	 * @param: @param image
	 * @param: @param top_num 返回结果top n,默认5.
	 * @param: @param filter_threshold 	默认0.95，可以通过该参数调节识别效果，降低非菜识别率.
	 * @param: @param baike_num 返回百科信息的结果数，默认不返回
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject dish(String image,Integer top_num,String filter_threshold,Integer baike_num);
	/**
	 * 
	 * @Title: logo   
	 * @Description: TODO(logo商标识别)   
	 * @param: @param image
	 * @param: @param custom_lib
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject logo(String image,Boolean custom_lib);
	/**
	 * 
	 * @Title: animal   
	 * @Description: TODO(动物识别)   
	 * @param: @param image
	 * @param: @param top_num
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject animal(String image,Integer top_num,Integer baike_num);
	
	/**
	 * 
	 * @Title: plant   
	 * @Description: TODO(植物识别)   
	 * @param: @param image
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject plant(String image,Integer baike_num);
	
	/**
	 * 
	 * @Title: flower   
	 * @Description: TODO(花卉识别)   
	 * @param: @param image
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject flower(String image,Integer top_num,Integer baike_num);
	
	/**
	 * 
	 * @Title: car   
	 * @Description: TODO(车辆识别)   
	 * @param: @param image
	 * @param: @param top_num
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject car(String image,Integer top_num,Integer baike_num);
	
	/**
	 * 
	 * @Title: logoAdd   
	 * @Description: TODO(logo商标添加)   
	 * @param: @param image
	 * @param: @param brief 检索时带回。此处要传对应的name与code字段，name长度小于100B，code长度小于150B。示例："{"name": "abc", "code":"ddd"}"
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject logoAdd(String image,String brief);
	/**
	 * @Title: logoDelete   
	 * @Description: TODO(logo商标删除)    
	 * @param: @param image
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject logoDeleteByImage(String image);
	/**
	 * 
	 * @Title: logoDeleteBySign   
	 * @Description: TODO(JSONObject)   
	 * @param: @param cont_sign 图片签名
	 * @param: @return      
	 * @return: JSONObject      
	 * @throws
	 */
	JSONObject logoDeleteBySign(String cont_sign);
}
