package com.ovopark.boot.edas.ai.image.service.dubbo;

import com.ovopark.boot.core.plugin.activerecord.GG;
/**
 * 
 * @ClassName:  ImageDubboService   
 * @Description:TODO(图像识别dubb服务方法)   
 * @author: Remiel_Mercy 
 * @date:   2019年1月18日 下午2:11:13   
 *     
 * @Copyright: 2019 www.ovopark.com Inc. All rights reserved.
 */
public interface ImageDubboService {
	/**
	 * 
	 * @Title: advancedGeneralDetect   
	 * @Description: TODO(通用物体和场景识别高级版)   
	 * @param: @param image
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 * 该请求用于通用物体及场景识别，即对于输入的一张图片（可正常解码，且长宽比适宜），输出图片中的多个物体及场景标签。
	 */
	GG advancedGeneralDetect(String image,Integer baike_num);
	
	
	GG objectDetect(String image,Integer baike_num);
	/**
	 * 
	 * @Title: dishDetect   
	 * @Description: TODO(菜品识别)   
	 * @param: @param image
	 * @param: @param top_num
	 * @param: @param filter_threshold
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG dishDetect(String image,Integer top_num,String filter_threshold,Integer baike_num);
	/**
	 * 
	 * @Title: logoDetect   
	 * @Description: TODO(logo识别)   
	 * @param: @param image
	 * @param: @param custom_lib
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG logoDetect(String image,Boolean custom_lib);
	/**
	 * 
	 * @Title: animalDetect   
	 * @Description: TODO(动物识别)   
	 * @param: @param image
	 * @param: @param top_num
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG animalDetect(String image,Integer top_num,Integer baike_num);
	/**
	 * 
	 * @Title: plantDetect   
	 * @Description: TODO(植物识别)   
	 * @param: @param image
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG plantDetect(String image,Integer baike_num);
	/**
	 * 
	 * @Title: carDetect   
	 * @Description: TODO(车辆识别)   
	 * @param: @param image
	 * @param: @param top_num
	 * @param: @param baike_num
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG carDetect(String image,Integer top_num,Integer baike_num);
	/**
	 * @Title: logoAdd   
	 * @Description: TODO(logo添加)   
	 * @param: @param image
	 * @param: @param brief
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG logoAdd(String image,String brief);
	
	/**
	 * 
	 * @Title: logoDeleteByImage   
	 * @Description: TODO(根据图片删除logo)   
	 * @param: @param image
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG logoDeleteByImage(String image);
	/**
	 * 
	 * @Title: logoDeleteBySign   
	 * @Description: TODO(根据签名删除logo)   
	 * @param: @param cont_sign
	 * @param: @return      
	 * @return: GG      
	 * @throws
	 */
	GG logoDeleteBySign(String cont_sign);
}
