package com.ovopark.boot.edas.ai.ocr.code;

import com.ovopark.boot.core.code.AbstractReturnCode;

/**
 * @author 刘帅
 * @ClassName
 * @Description TODO
 * @Date 2019/5/23 10:09
 * @Version 1.0
 **/
public class AiOcrReturnCode extends AbstractReturnCode {
    /**
     * 初始化一个对外暴露的ReturnCode(用于客户端异常处理)
     *
     * @param desc
     * @param name
     * @param code
     */
    public AiOcrReturnCode(String desc, String name, int code) {
        super(desc, name, code);
    }

    private static final long serialVersionUID = 1L;
    // 服务请求超时
    public static final int SERVICE_TIMEOUT_CODE = 403066;
    public final static AbstractReturnCode SERVICE_TIMEOUT = new AiOcrReturnCode("服务请求超时", "SERVICE_TIMEOUT",
            SERVICE_TIMEOUT_CODE);
    // token格式有误
    public static final int TOKEN_FORMAT_ERROR_CODE = 403096;
    public final static AbstractReturnCode TOKEN_FORMAT_ERROR = new AiOcrReturnCode("token格式有误", "TOKEN_FORMAT_ERROR",
            TOKEN_FORMAT_ERROR_CODE);

    // token不能为空
    public static final int TOKEN_NOT_NULL_CODE = 403098;
    public final static AbstractReturnCode TOKEN_NOT_NULL = new AiOcrReturnCode("token不能为空", "TOKEN_NOT_NULL",
            TOKEN_NOT_NULL_CODE);
    //json解析异常
    public static final int JSON_EXCEPTION_CODE = 403101;
    public final static AbstractReturnCode JSON_EXCEPTION = new AiOcrReturnCode("json解析异常", "JSON_EXCEPTION",
            JSON_EXCEPTION_CODE);

    // api服务异常
    public static final int API_SYSTEM_ERROR_CODE = 403999;
    public final static AbstractReturnCode API_SYSTEM_ERROR = new AiOcrReturnCode("api服务未知异常", "API_SYSTEM_ERROR",
            API_SYSTEM_ERROR_CODE);
}
