/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.boot.config;

import com.ovopark.boot.core.code.AbstractReturnCode;
import com.ovopark.boot.core.code.ApiReturnCode;
import com.ovopark.boot.core.code.support.ApiCodeResult;
import com.ovopark.boot.edas.ai.ocr.code.AiOcrReturnCode;
import com.ovopark.boot.kit.lang.DigitKit;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    @Value(value="${systemid}")
    private int systemid;
    static int index = 3;

    @ExceptionHandler(value={Exception.class})
    public Object handleBadRequest(Exception e) {
        BindingResult bindingResult;
        if (e instanceof BindException && null != (bindingResult = ((BindException)e).getBindingResult()) && bindingResult.hasErrors()) {
            ArrayList jsonList = new ArrayList();
            bindingResult.getFieldErrors().stream().forEach(fieldError -> {
                HashMap<String, String> jsonObject = new HashMap<String, String>(2);
                jsonObject.put("field", fieldError.getField());
                jsonObject.put("warning", fieldError.getDefaultMessage());
                jsonList.add(jsonObject);
            });
            AbstractReturnCode Abcode = ApiReturnCode.PARAMETER_VALIDATE_ERROR;
            int code = DigitKit.join2Int((Object[])new Object[]{this.systemid, DigitKit.subAfer2Str((Object)Abcode.getCode(), (int)index)});
            Abcode.setCode(code);
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            return ApiCodeResult.error((AbstractReturnCode)Abcode, jsonList);
        }
        if (e instanceof MissingServletRequestParameterException) {
            AbstractReturnCode Abcode = ApiReturnCode.PARAMETER_VALIDATE_ERROR;
            int code = DigitKit.join2Int((Object[])new Object[]{this.systemid, DigitKit.subAfer2Str((Object)Abcode.getCode(), (int)index)});
            Abcode.setCode(code);
            ArrayList jsonList = new ArrayList();
            HashMap<String, String> jsonObject = new HashMap<String, String>(2);
            jsonObject.put("field", ((MissingServletRequestParameterException)e).getParameterName());
            jsonObject.put("warning", e.getMessage());
            jsonList.add(jsonObject);
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            return ApiCodeResult.error((AbstractReturnCode)Abcode, jsonList);
        }
        if (e instanceof MethodArgumentNotValidException && null != (bindingResult = ((MethodArgumentNotValidException)e).getBindingResult()) && bindingResult.hasErrors()) {
            ArrayList jsonList = new ArrayList();
            bindingResult.getFieldErrors().stream().forEach(fieldError -> {
                HashMap<String, String> jsonObject = new HashMap<String, String>(2);
                jsonObject.put("field", fieldError.getField());
                jsonObject.put("warning", fieldError.getDefaultMessage());
                jsonList.add(jsonObject);
            });
            AbstractReturnCode Abcode = ApiReturnCode.PARAMETER_VALIDATE_ERROR;
            int code = DigitKit.join2Int((Object[])new Object[]{this.systemid, DigitKit.subAfer2Str((Object)Abcode.getCode(), (int)index)});
            Abcode.setCode(code);
            logger.debug("Rest request error, {}", (Object)e.getMessage());
            return ApiCodeResult.error((AbstractReturnCode)Abcode, jsonList);
        }
        logger.error("Error: handleBadRequest StackTrace : {}", (Throwable)e);
        return ApiCodeResult.error((AbstractReturnCode)AiOcrReturnCode.API_SYSTEM_ERROR);
    }
}

