package com.coco.sdk.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.coco.sdk.common.Const;
import com.coco.sdk.em.SecurityType;

/**
    * @ClassName: ApiRef
    * @Description: TODO(接口方法定义)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年9月20日 上午12:31:02
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface ApiRef {
	/**方法名**/
	String method();
	/**方法用途**/
	String value();
	/**POST,还是GET请求**/
	String request() default Const.POST;
	/**备注**/
	String desc();
	/**是否忽略签名(默认需要签名)**/
	boolean IgnoreSign() default false;  
    /** 调用接口所需的安全级别(默认无任何安全风险的接口)**/
    SecurityType security() default SecurityType.None;
	/**请求地址**/
	String url();
	/**接口负责人**/
	String owner() ;
	/**上行或下行接口s**/
	String interfaceType() default Const.INTERFACETYPE_UP;
	/**接口版本        接口版本+接口名 如v1-open.demo.queryOpenAccount为接口的唯一标识,如仅仅修改url中的版本号，接口注册服务时会覆盖当前这个版本 **/
    String version();
}