package com.coco.sdk.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
/**
    * @ClassName: RequestHeader
    * @Description: TODO(请求头注解)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date  2017年12月8日 上午9:22:51 
    *
 */
@Target(ElementType.PARAMETER)
@Retention(RetentionPolicy.RUNTIME)
public @interface RequestHeader {
	/**
     * 是否为必要参数
     */
    boolean required();

    /**
     * 参数名称
     */
    String name();

    /**
     * 参数注释
     */
    String desc();
    /**
     * 参数类型
     */
    String type();
    
    /**
     * 示例
     */
    String eg();
    
    /**
     * 最大长度
     */
    String maxlength();
}
