/*
 * Decompiled with CFR 0.152.
 */
package com.coco.sdk.em;

public enum SecurityType {
    Test(-1),
    None(0),
    SeceretUserToken(1),
    OAuthVerified(2),
    RegisteredDevice(16),
    User(32),
    UserLogin(256),
    UserAuth(512),
    Integrated(0x10000000),
    Internal(0x20000000),
    Document(0x40000000);

    private int code;
    private static final int EXPIRABLE;
    private static final int TOKEN_REQUIRED;

    private SecurityType(int code) {
        this.code = code;
    }

    public boolean check(int auth) {
        return (auth & this.code) == this.code;
    }

    public boolean contains(int auth) {
        return (auth & this.code) != 0;
    }

    public boolean check(SecurityType auth) {
        return (auth.code & this.code) == this.code;
    }

    public int authorize(int auth) {
        return auth | this.code;
    }

    public static boolean isNone(int auth) {
        return auth == 0;
    }

    public static boolean expirable(int auth) {
        return (auth & EXPIRABLE) != 0;
    }

    public static boolean requireToken(int auth) {
        return (auth & TOKEN_REQUIRED) != 0;
    }

    static {
        EXPIRABLE = SecurityType.OAuthVerified.code | SecurityType.User.code | SecurityType.UserLogin.code | SecurityType.SeceretUserToken.code;
        TOKEN_REQUIRED = SecurityType.RegisteredDevice.code | SecurityType.OAuthVerified.code | SecurityType.User.code | SecurityType.UserLogin.code;
    }
}

