/*
 * Decompiled with CFR 0.152.
 */
package com.coco.sdk.ext.spring.handler;

import com.coco.sdk.ext.spring.annotation.ApiVersion;
import com.coco.sdk.ext.spring.mvc.ApiVersionCondition;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.servlet.mvc.condition.RequestCondition;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class ApiHandlerMapping
extends RequestMappingHandlerMapping {
    protected RequestCondition<ApiVersionCondition> getCustomTypeCondition(Class<?> handlerType) {
        ApiVersion apiVersion = (ApiVersion)AnnotationUtils.findAnnotation(handlerType, ApiVersion.class);
        return this.createCondition(apiVersion);
    }

    protected RequestCondition<ApiVersionCondition> getCustomMethodCondition(Method method) {
        ApiVersion apiVersion = (ApiVersion)AnnotationUtils.findAnnotation((Method)method, ApiVersion.class);
        return this.createCondition(apiVersion);
    }

    private RequestCondition<ApiVersionCondition> createCondition(ApiVersion apiVersion) {
        return apiVersion == null ? null : new ApiVersionCondition(apiVersion.value());
    }
}

