package com.ovopark.cloud.cache;

public abstract class BaseCacheFactory implements Cache{
	@SuppressWarnings("unchecked")
	public <T> T get(String cacheName, Object key, IDataLoader iLoader) {
		Object data = get(cacheName, key);
		if (data == null) {
			data = iLoader.load();
			put(cacheName, key, data);
		}
		return (T) data;
	}

	@SuppressWarnings("unchecked")
	public <T> T get(String cacheName, Object key, Class<? extends IDataLoader> iLoaderClass) {
		Object data = get(cacheName, key);
		if (data == null) {
			try {
				IDataLoader dataLoader = iLoaderClass.newInstance();
				data = dataLoader.load();
				put(cacheName, key, data);
			} catch (Exception e) {
				throw new RuntimeException(e);
			}
		}
		return (T) data;
	}
}
