package com.ovopark.cloud.cache.config;

import com.ovopark.cloud.cache.Cache;
import com.ovopark.cloud.cache.Redis;
import com.ovopark.cloud.cache.ehCache.EhcacheFactory;
import com.ovopark.cloud.cache.redis.RedisFactory;

public class Config {
	private static final Config me = new Config();
	private Config() {
	}
	public static Config me() {
		return me;
	}
	
	private Cache defaultCacheFactory;
	
	private Redis redisCacheFactory;
	/**
	 * 默认缓存工厂类
	 */
	public Cache getDefaultCacheFactory() {
		defaultCacheFactory=EhcacheFactory.createEhcache();
		return defaultCacheFactory;
	}
	public void setDefaultCacheFactory(Cache defaultCacheFactory) {
		this.defaultCacheFactory = defaultCacheFactory;
	}
	public Redis getRedisCacheFactory() {
		redisCacheFactory=RedisFactory.createRedis();
		return redisCacheFactory;
	}
	public void setRedisCacheFactory(Redis redisCacheFactory) {
		this.redisCacheFactory = redisCacheFactory;
	}
	
	
}
