package com.ovopark.cloud.cache.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.ovopark.cloud.cache.Redis;
import com.ovopark.cloud.cache.config.Config;



/**
 * 
    * @ClassName: CoCoRedisKit
    * @Description: TODO(Redis工具类)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年8月28日 上午10:26:46
 */
public class CoCoRedisKit {
	private static Redis  redis= Config.me().getRedisCacheFactory();
	
	public static boolean  set(Object key, String value) {
		return redis.set(key, value);
	}
	public static boolean  set(Object key, String value,int index) {
		return redis.set(key, value,index);
	}
	public static boolean  set(Object key, String value,String nxxx, String expx, long time) {
		return redis.set(key, value,nxxx,expx,time);
	}
	public static boolean  set(Object key, String value,String nxxx, String expx, long time,int index) {
		return redis.set(key, value,nxxx,expx,time,index);
	}
	public static <T> boolean  setPoJo(Object key,  Object pojo) {
		return redis.setPoJo(key, pojo);
	}
	public static <T> boolean  setPoJo(Object key,  Object pojo,int index) {
		return redis.setPoJo(key, pojo,index);
	}
	public static <T> boolean  setPoJo(Object key,  Object pojo,String nxxx, String expx, long time) {
		return redis.setPoJo(key, pojo,nxxx,expx,time);
	}
	public static <T> boolean  setPoJo(Object key,  Object pojo,String nxxx, String expx, long time,int index) {
		return redis.setPoJo(key, pojo,nxxx,expx,time,index);
	}
	public static <T> boolean  setlist(Object key, List<T> list) {
		return redis.setlist(key, list);
	}
	public static <T> boolean  setlist(Object key, List<T> list,int index) {
		return redis.setlist(key, list,index);
	}
	public static <T> boolean  setlist(Object key, List<T> list,String nxxx, String expx, long time) {
		return redis.setlist(key, list,nxxx,expx,time);
	}
	public static <T> boolean  setlist(Object key, List<T> list,String nxxx, String expx, long time,int index) {
		return redis.setlist(key, list,nxxx,expx,time,index);
	}
	public static <T> T get(Object key, Class<T> clazz) {
		return redis.get(key,clazz);
	}
	public static <T> T get(Object key, Class<T> clazz,int index) {
		return redis.get(key,clazz,index);
	}
	public static Object  get(Object key) {
		return redis.get(key);
	}
	public static Object  get(Object key,int index) {
		return redis.get(key,index);
	}
	public static  <T> List<T> getList(Object key) {
		return redis.getList(key);
	}
	public static  <T> List<T> getList(Object key,int index) {
		return redis.getList(key,index);
	}
	public static  Long  del(Object key) {
		return redis.del(key);
	}
	public static  Long  del(Object key,int index) {
		return redis.del(key,index);
	}
	public static Set<String> keys(String pattern) {
		return redis.keys(pattern);
	}
	public static Set<String> keys(String pattern,int index) {
		return redis.keys(pattern,index);
	}
	public static boolean  setExpire(Object key, String value,int time){
		return redis.setExpire(key, value, time);
	}
	public static boolean  setExpire(Object key, String value,int time,int index){
		return redis.setExpire(key, value, time,index);
	}
	public static <T> boolean setPoJoExpire(Object key, Object pojo, int time) {
		return redis.setPoJoExpire(key, pojo, time);
	}
	public static <T> boolean setPoJoExpire(Object key, Object pojo, int time, int index) {
		return redis.setPoJoExpire(key, pojo, time, index);
	}
	public static <T> boolean setlistExpire(Object key, List<T> list, int time) {
		return redis.setlistExpire(key, list, time);
	}
	public static <T> boolean setlistExpire(Object key, List<T> list, int time, int index) {
		return redis.setlistExpire(key, list, time, index);
	}
	public static Long ttl(Object key) {
		return redis.ttl(key);
	}
	public static Long ttl(Object key,int index) {
		return redis.ttl(key,index);
	}
	public static Long zadd(String key, double score, String member) {
		return redis.zadd(key,score,member);
	}
	public static Long zadd(String key, double score, String member, int index) {
		return redis.zadd(key,score,member,index);
	}
	public static Double zscore(String key,String member) {
		return redis.zscore(key,member);
	}
	public static Double zscore(String key,String member, int index) {
		return redis.zscore(key,member,index);
	}
	public static Long zrem(String key, String member) {
		return redis.zrem(key,member);
	}
	public static Long zrem(String key, String member, int index) {
		return redis.zrem(key,member,index);
	}
	public static Set<String> zrange(String key,int start,int end, int index) {
		return redis.zrange(key,start,end,index);
	}
	public static Set<String> zrevrange(String key,int start,int end) {
		return redis.zrevrange(key,start,end);
	}
	public static Set<String> zrevrange(String key,int start,int end, int index) {
		return redis.zrevrange(key,start,end,index);
	}
	public static Long zcard(String key) {
		return redis.zcard(key);
	}
	public static Long zcard(String key ,int index) {
		return redis.zcard(key,index);
	}

	public static Long incr(String key) {
		return redis.incr(key);
	}
	public static Long incr(String key ,int index) {
		return redis.incr(key,index);
	}
	public static Long hset(String key,String field,String value) {
		return redis.hset(key,field,value);
	}
	public static Long hset(String key,String field,String value,int index) {
		return redis.hset(key,field,value,index);
	}
	
	public static String hget(String key,String field) {
		return redis.hget(key, field);
	}
	public static String hget(String key,String field,int index) {
		return redis.hget(key, field,index);
	}
	
	public static Long hdel(String key,String field) {
		return redis.hdel(key, field);
	}
	
	public static Long hdel(String key,String field,int index) {
		return redis.hdel(key, field,index);
	}
	
	public static Map<String, String> hgetall(String key){
		return redis.hgetall(key);
	}
	
	public static Map<String, String> hgetall(String key,int index){
		return redis.hgetall(key,index);
	}
	
	public static List<String> scan(String key){
		return redis.scan(key);
	}
	
	public static List<String> scan(String key,int index){
		return redis.scan(key,index);
	}
	
}


