/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.search.controller;

import com.ovopark.cloud.search.model.BaseResult;
import com.ovopark.cloud.search.model.DeviceLog;
import com.ovopark.cloud.search.model.DeviceLogQuery;
import com.ovopark.cloud.search.service.DeviceLogService;
import com.ovopark.cloud.search.stream.DeviceInfo;
import com.ovopark.cloud.search.stream.SpringContextGlobalUserStreamState;
import com.ovopark.cloud.search.stream.TopN;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/device-log"})
public class DeviceLogController {
    private static final Logger log = LoggerFactory.getLogger(DeviceLogController.class);
    @Autowired
    private DeviceLogService deviceLogService;
    @Autowired
    private SpringContextGlobalUserStreamState globalUserStreamState;

    @GetMapping(value={"search"})
    public BaseResult<List<DeviceLog>> search(DeviceLogQuery deviceLogQuery) {
        return BaseResult.success(this.deviceLogService.search(deviceLogQuery));
    }

    @GetMapping(value={"user/latest"})
    public BaseResult<List<DeviceInfo>> search(@RequestParam Integer userId) {
        TopN topN = this.globalUserStreamState.topN(userId);
        ArrayList<DeviceInfo> deviceInfoList = new ArrayList<DeviceInfo>(topN.top());
        return BaseResult.success(deviceInfoList);
    }
}

