/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.search.stream;

import com.ovopark.cloud.search.stream.DeviceInfo;
import com.ovopark.cloud.search.stream.GlobalStreamState;
import com.ovopark.cloud.search.stream.LinkedListTop;
import com.ovopark.cloud.search.stream.TopN;
import com.ovopark.cloud.search.stream.TopNProperties;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultGlobalStreamState<G>
implements GlobalStreamState<G> {
    private Map<G, TopN> topNMap = new ConcurrentHashMap<G, TopN>();
    private final TopNProperties topNProperties;

    public DefaultGlobalStreamState(TopNProperties topNProperties) {
        this.topNProperties = topNProperties;
    }

    @Override
    public void merge(G groupId, List<DeviceInfo> top) {
        TopN topN = this.getOrNew(groupId);
        for (DeviceInfo deviceInfo : top) {
            topN.push(deviceInfo.getDeviceId(), deviceInfo.getTime());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TopN getOrNew(G groupId) {
        TopN topN = this.topNMap.get(groupId);
        if (topN == null) {
            DefaultGlobalStreamState defaultGlobalStreamState = this;
            synchronized (defaultGlobalStreamState) {
                topN = this.topNMap.get(groupId);
                if (topN == null) {
                    topN = new LinkedListTop(this.topNProperties.getTopN());
                    this.topNMap.put(groupId, topN);
                }
            }
        }
        return topN;
    }

    @Override
    public TopN topN(G groupId) {
        return this.topNMap.get(groupId);
    }

    @Override
    public Map<G, TopN> all() {
        return Collections.unmodifiableMap(this.topNMap);
    }
}

