/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.search.stream;

import com.ovopark.cloud.search.stream.DeviceInfo;
import com.ovopark.cloud.search.stream.TopN;
import java.util.BitSet;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class LinkedListTop
implements TopN {
    private final int top;
    private final LinkedList<DeviceInfo> deviceInfoList;
    private BitSet bitSet = new BitSet();
    private long ver;

    public LinkedListTop(int top) {
        this.top = top;
        this.deviceInfoList = new LinkedList();
    }

    @Override
    public void push(int deviceId, long time) {
        if (time <= 0L) {
            return;
        }
        if (this.bitSet.get(deviceId)) {
            return;
        }
        int foundIndex = -1;
        for (int i = this.deviceInfoList.size() - 1; i >= 0; --i) {
            DeviceInfo larger = this.deviceInfoList.get(i);
            long maxTime = larger.getTime();
            if (time > maxTime) {
                foundIndex = i;
                break;
            }
            long minTime = 0L;
            if (i - 1 >= 0) {
                minTime = this.deviceInfoList.get(i - 1).getTime();
            }
            if (time > larger.getTime() || time <= minTime) continue;
            foundIndex = i - 1;
            break;
        }
        DeviceInfo deviceInfo = new DeviceInfo();
        deviceInfo.setDeviceId(deviceId);
        deviceInfo.setTime(time);
        if (this.deviceInfoList.size() == this.top) {
            DeviceInfo removeFirst;
            if (foundIndex == -1) {
                return;
            }
            if (foundIndex == this.deviceInfoList.size() - 1) {
                removeFirst = this.deviceInfoList.removeFirst();
                this.deviceInfoList.offer(deviceInfo);
                this.bitSet.set(deviceId);
                this.bitSet.clear(removeFirst.getDeviceId());
                ++this.ver;
            } else {
                removeFirst = this.deviceInfoList.removeFirst();
                this.deviceInfoList.add(foundIndex, deviceInfo);
                this.bitSet.set(deviceId);
                this.bitSet.clear(removeFirst.getDeviceId());
                ++this.ver;
            }
        } else if (foundIndex == -1) {
            this.deviceInfoList.push(deviceInfo);
            this.bitSet.set(deviceId);
            ++this.ver;
        } else {
            this.deviceInfoList.add(foundIndex, deviceInfo);
            this.bitSet.set(deviceId);
            ++this.ver;
        }
    }

    @Override
    public boolean contains(int deviceId) {
        for (int i = 0; i < this.deviceInfoList.size(); ++i) {
            DeviceInfo deviceInfo = this.deviceInfoList.get(i);
            if (deviceInfo.getDeviceId() != deviceId) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<DeviceInfo> top() {
        return Collections.unmodifiableList(this.deviceInfoList);
    }

    @Override
    public long updatedVer() {
        return this.ver;
    }
}

