/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.search.stream;

import com.ovopark.cloud.search.model.DeviceLogPut;
import com.ovopark.cloud.search.stream.DefaultDeviceLogStream;
import com.ovopark.cloud.search.stream.DeviceInfo;
import com.ovopark.cloud.search.stream.DeviceLogStream;
import com.ovopark.cloud.search.stream.GroupId;
import com.ovopark.cloud.search.stream.SyncModel;
import com.ovopark.cloud.search.stream.TopN;
import com.ovopark.cloud.search.stream.TopNProperties;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public abstract class MultiNodeDeviceLogStream<G>
implements DeviceLogStream {
    private static final Logger log = LoggerFactory.getLogger(MultiNodeDeviceLogStream.class);
    private final GroupId<G> userIdGroup;
    private final Map<G, DeviceLogStreamHolder> local = new ConcurrentHashMap<G, DeviceLogStreamHolder>();
    private ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "topN-sync");
        }
    });
    private final DiscoveryClient discoveryClient;
    private final RestTemplate restTemplate;
    private final TopNProperties topNProperties;
    private static final String PATH = "/ovopark-search/device-log/node/sync";
    private long syncCount;

    public MultiNodeDeviceLogStream(GroupId<G> userIdGroup, DiscoveryClient discoveryClient, RestTemplate restTemplate, TopNProperties topNProperties) {
        this.userIdGroup = userIdGroup;
        this.discoveryClient = discoveryClient;
        this.restTemplate = restTemplate;
        this.topNProperties = topNProperties;
        this.scheduledExecutorService.scheduleWithFixedDelay(this::sync, 30L, 3L, TimeUnit.SECONDS);
    }

    protected abstract SyncModel<G> syncModel(Map<G, List<DeviceInfo>> var1);

    private void sync() {
        try {
            ++this.syncCount;
            HashMap<G, List<DeviceInfo>> syncListMap = new HashMap<G, List<DeviceInfo>>();
            for (Map.Entry<G, DeviceLogStreamHolder> streamHolderEntry : this.local.entrySet()) {
                DeviceLogStreamHolder streamHolder = streamHolderEntry.getValue();
                G groupId = streamHolderEntry.getKey();
                DeviceLogStream deviceLogStream = streamHolder.deviceLogStream;
                if (streamHolder.updatedVer < deviceLogStream.topUpdatedVer()) {
                    syncListMap.put(groupId, deviceLogStream.topN().top());
                    streamHolder.updatedVer = deviceLogStream.topUpdatedVer();
                    continue;
                }
                if (this.syncCount % 1L != 0L) continue;
                syncListMap.put(groupId, deviceLogStream.topN().top());
                streamHolder.updatedVer = deviceLogStream.topUpdatedVer();
            }
            SyncModel syncModel = this.syncModel(syncListMap);
            List serviceInstanceList = this.discoveryClient.getInstances("ovopark-search");
            for (ServiceInstance serviceInstance : serviceInstanceList) {
                URI instanceUri = serviceInstance.getUri();
                HttpEntity request = new HttpEntity(syncModel);
                ResponseEntity responseEntity = this.restTemplate.postForEntity(instanceUri + PATH, (Object)request, String.class, new Object[0]);
                log.debug((String)responseEntity.getBody());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeviceLogStream getOrNew(G groupId) {
        DeviceLogStreamHolder deviceLogStream = this.local.get(groupId);
        if (deviceLogStream == null) {
            MultiNodeDeviceLogStream multiNodeDeviceLogStream = this;
            synchronized (multiNodeDeviceLogStream) {
                deviceLogStream = this.local.get(groupId);
                if (deviceLogStream == null) {
                    deviceLogStream = new DeviceLogStreamHolder(new DefaultDeviceLogStream(this.topNProperties.getTopN()));
                    this.local.put(groupId, deviceLogStream);
                }
            }
        }
        return deviceLogStream.deviceLogStream;
    }

    @Override
    public void flow(DeviceLogPut deviceLogPut) {
        this.getOrNew(this.userIdGroup.group(deviceLogPut)).flow(deviceLogPut);
    }

    @Override
    public TopN topN() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long topUpdatedVer() {
        throw new UnsupportedOperationException();
    }

    private class DeviceLogStreamHolder {
        private final DeviceLogStream deviceLogStream;
        private long updatedVer;

        public DeviceLogStreamHolder(DeviceLogStream deviceLogStream) {
            this.deviceLogStream = deviceLogStream;
        }
    }
}

