/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.search.stream;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ovopark.cloud.search.model.DeviceLogTopN;
import com.ovopark.cloud.search.stream.DefaultGlobalUserGroupStreamState;
import com.ovopark.cloud.search.stream.DeviceInfo;
import com.ovopark.cloud.search.stream.GlobalStreamStateStoreSync;
import com.ovopark.cloud.search.stream.GroupTopN;
import com.ovopark.cloud.search.stream.NodeSelect;
import com.ovopark.cloud.search.stream.StreamState;
import com.ovopark.cloud.search.stream.TopN;
import com.ovopark.cloud.search.stream.TopNProperties;
import com.ovopark.cloud.search.stream.UserGroupSync;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.stereotype.Component;

@Component
public class SpringContextGlobalUserStreamState
implements StreamState<Integer>,
GroupTopN<Integer> {
    private static final Logger log = LoggerFactory.getLogger(SpringContextGlobalUserStreamState.class);
    private static final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "group-merge-" + ++this.index);
            return thread;
        }
    }, new ThreadPoolExecutor.AbortPolicy());
    private static final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "state-fsync-" + ++this.index);
            return thread;
        }
    }, new ThreadPoolExecutor.AbortPolicy());
    @Autowired
    private NodeSelect nodeSelect;
    @Autowired
    private ObjectMapper objectMapper;
    private DefaultGlobalUserGroupStreamState globalUserGroupStreamState;
    @Autowired
    private TopNProperties topNProperties;
    @Autowired
    private GlobalStreamStateStoreSync globalStreamStateStoreSync;

    private void fsync() {
        try {
            ServiceInstance serviceInstance = this.nodeSelect.firstIsMyself();
            if (serviceInstance == null) {
                return;
            }
            ArrayList<DeviceLogTopN> deviceLogTopNList = new ArrayList<DeviceLogTopN>();
            Map all = this.globalUserGroupStreamState.all();
            for (Map.Entry entry : all.entrySet()) {
                Integer key = (Integer)entry.getKey();
                TopN topN = entry.getValue();
                DeviceLogTopN deviceLogTopN = new DeviceLogTopN();
                deviceLogTopN.setId(key);
                deviceLogTopN.setUserId(key);
                deviceLogTopN.setTopList(this.objectMapper.writeValueAsString(topN.top()));
                deviceLogTopNList.add(deviceLogTopN);
            }
            this.globalStreamStateStoreSync.fsync(deviceLogTopNList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @PostConstruct
    private void init() {
        this.globalUserGroupStreamState = new DefaultGlobalUserGroupStreamState(this.topNProperties);
        scheduledExecutorService.scheduleWithFixedDelay(this::fsync, 60L, 5L, TimeUnit.SECONDS);
        try {
            List<DeviceLogTopN> all = this.globalStreamStateStoreSync.read();
            for (DeviceLogTopN deviceLogTopN : all) {
                int userId = deviceLogTopN.getUserId();
                String topList = deviceLogTopN.getTopList();
                MappingIterator values = this.objectMapper.readerForListOf(DeviceInfo.class).readValues(topList);
                ArrayList<DeviceInfo> deviceInfoList = new ArrayList<DeviceInfo>();
                values.forEachRemaining(deviceInfo -> deviceInfoList.add((DeviceInfo)deviceInfo));
                this.globalUserGroupStreamState.merge(userId, deviceInfoList);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void merge(Integer groupId, List<DeviceInfo> top) {
        this.globalUserGroupStreamState.merge(groupId, top);
    }

    @Override
    public TopN topN(Integer groupId) {
        return this.globalUserGroupStreamState.topN(groupId);
    }

    public void merge(final UserGroupSync userGroupSync) {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Map listMap = userGroupSync.getSyncList();
                    for (Map.Entry entry : listMap.entrySet()) {
                        SpringContextGlobalUserStreamState.this.globalUserGroupStreamState.merge((Integer)entry.getKey(), entry.getValue());
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        });
    }
}

