/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.search.stream;

import com.ovopark.cloud.search.model.DeviceLogPut;
import com.ovopark.cloud.search.stream.DeviceLogStream;
import com.ovopark.cloud.search.stream.MultiNodeUserGroupDeviceStream;
import com.ovopark.cloud.search.stream.TopN;
import com.ovopark.cloud.search.stream.TopNProperties;
import com.ovopark.cloud.search.stream.UserGroup;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class SpringContextUserGroupDeviceStream
implements DeviceLogStream {
    private static final Logger log = LoggerFactory.getLogger(SpringContextUserGroupDeviceStream.class);
    private static final ExecutorService executorService = new ThreadPoolExecutor(1, 1, 600L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(Integer.MAX_VALUE), new ThreadFactory(){
        int index = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "group-push-" + ++this.index);
            return thread;
        }
    }, new ThreadPoolExecutor.AbortPolicy());
    @Autowired
    private DiscoveryClient discoveryClient;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private TopNProperties topNProperties;
    private MultiNodeUserGroupDeviceStream multiNodeUserGroupDeviceStream;

    @PostConstruct
    private void init() {
        this.multiNodeUserGroupDeviceStream = new MultiNodeUserGroupDeviceStream(new UserGroup(), this.discoveryClient, this.restTemplate, this.topNProperties);
    }

    @Override
    public void flow(final DeviceLogPut deviceLogPut) {
        executorService.execute(new Runnable(){

            @Override
            public void run() {
                SpringContextUserGroupDeviceStream.this.multiNodeUserGroupDeviceStream.flow(deviceLogPut);
            }
        });
    }

    @Override
    public TopN topN() {
        return this.multiNodeUserGroupDeviceStream.topN();
    }

    @Override
    public long topUpdatedVer() {
        return this.multiNodeUserGroupDeviceStream.topUpdatedVer();
    }
}

