/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.DTO;

import com.ovopark.cloud.DTO.CloudMonthServiceNumDTO;
import java.io.Serializable;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CloudMonthNumDTO
implements Serializable {
    private static final long serialVersionUID = -6030371966561106368L;
    private String date;
    private int num;
    private int month;

    public static List<CloudMonthNumDTO> fromMonthServiceMap(Map<String, List<CloudMonthServiceNumDTO>> monthServiceMap) {
        LinkedList<CloudMonthNumDTO> result = new LinkedList();
        if (monthServiceMap != null) {
            for (Map.Entry<String, List<CloudMonthServiceNumDTO>> entry : monthServiceMap.entrySet()) {
                if (StringUtils.isEmpty((CharSequence)entry.getKey())) continue;
                CloudMonthNumDTO cloudMonthNumDTO = new CloudMonthNumDTO();
                cloudMonthNumDTO.setMonth(Integer.parseInt(entry.getKey().split("-")[1]));
                cloudMonthNumDTO.setDate(cloudMonthNumDTO.getMonth() + "\u6708");
                if (entry.getValue() != null) {
                    cloudMonthNumDTO.setNum(entry.getValue().stream().mapToInt(CloudMonthServiceNumDTO::getNum).sum());
                }
                result.add(cloudMonthNumDTO);
            }
        }
        result = result.stream().sorted(Comparator.comparing(CloudMonthNumDTO::getMonth)).collect(Collectors.toList());
        return result;
    }

    public String getDate() {
        return this.date;
    }

    public int getNum() {
        return this.num;
    }

    public int getMonth() {
        return this.month;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setNum(int num) {
        this.num = num;
    }

    public void setMonth(int month) {
        this.month = month;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudMonthNumDTO)) {
            return false;
        }
        CloudMonthNumDTO other = (CloudMonthNumDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNum() != other.getNum()) {
            return false;
        }
        if (this.getMonth() != other.getMonth()) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        return !(this$date == null ? other$date != null : !this$date.equals(other$date));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CloudMonthNumDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNum();
        result = result * 59 + this.getMonth();
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        return result;
    }

    public String toString() {
        return "CloudMonthNumDTO(date=" + this.getDate() + ", num=" + this.getNum() + ", month=" + this.getMonth() + ")";
    }
}

