/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.VO;

import com.ovopark.cloud.DTO.CloudAvgTimeDTO;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class CloudAvgTimeVO
implements Serializable {
    private String date;
    private List<CloudAvgTimeStoreVO> cloudAvgTimeStoreList;

    public static List<CloudAvgTimeVO> fromAvgTimeMap(Map<String, List<CloudAvgTimeDTO>> avgTimeMap, String storeId, boolean hasDay, List<String> timeRange) {
        LinkedList<CloudAvgTimeVO> result = new LinkedList<CloudAvgTimeVO>();
        if (hasDay) {
            List timeList = avgTimeMap.keySet().stream().sorted().collect(Collectors.toList());
            for (String time : timeList) {
                CloudAvgTimeVO cloudAvgTime = new CloudAvgTimeVO();
                String date = time.substring(5, 10).replace("-", "/");
                List<CloudAvgTimeStoreVO> cloudAvgTimeStoreList = CloudAvgTimeVO.getAvgTimeStoreList(avgTimeMap.get(time), storeId);
                cloudAvgTime.setCloudAvgTimeStoreList(cloudAvgTimeStoreList);
                cloudAvgTime.setDate(date);
                result.add(cloudAvgTime);
            }
        } else {
            List weekSign = avgTimeMap.keySet().stream().map(Integer::parseInt).distinct().sorted().collect(Collectors.toList());
            for (int index = 0; index < weekSign.size(); ++index) {
                CloudAvgTimeVO cloudAvgTime = new CloudAvgTimeVO();
                cloudAvgTime.setDate(timeRange.get(index));
                List<CloudAvgTimeStoreVO> cloudAvgTimeStoreList = CloudAvgTimeVO.getAvgTimeStoreList(avgTimeMap.get(String.valueOf(weekSign.get(index))), storeId);
                cloudAvgTime.setCloudAvgTimeStoreList(cloudAvgTimeStoreList);
                result.add(cloudAvgTime);
            }
        }
        return result;
    }

    private static List<CloudAvgTimeStoreVO> getAvgTimeStoreList(List<CloudAvgTimeDTO> avgTime, String storeId) {
        LinkedList<CloudAvgTimeStoreVO> cloudAvgTimeStoreList = new LinkedList<CloudAvgTimeStoreVO>();
        if (avgTime != null) {
            for (CloudAvgTimeDTO cloudAvgTimeDTO : avgTime) {
                if (StringUtils.isNotEmpty((CharSequence)storeId) && !storeId.equals(cloudAvgTimeDTO.getDepId())) continue;
                CloudAvgTimeStoreVO storeVO = new CloudAvgTimeStoreVO();
                storeVO.setStoreName(cloudAvgTimeDTO.getDepName());
                String timeFormat = String.format("%.2f", (double)cloudAvgTimeDTO.getAvgTime().longValue() / 60.0);
                storeVO.setAvgTime(Double.parseDouble(timeFormat));
                storeVO.setRemark(timeFormat.replace(".", "\u5206").concat("\u79d2"));
                cloudAvgTimeStoreList.add(storeVO);
            }
        }
        return cloudAvgTimeStoreList;
    }

    public String getDate() {
        return this.date;
    }

    public List<CloudAvgTimeStoreVO> getCloudAvgTimeStoreList() {
        return this.cloudAvgTimeStoreList;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public void setCloudAvgTimeStoreList(List<CloudAvgTimeStoreVO> cloudAvgTimeStoreList) {
        this.cloudAvgTimeStoreList = cloudAvgTimeStoreList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CloudAvgTimeVO)) {
            return false;
        }
        CloudAvgTimeVO other = (CloudAvgTimeVO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$date = this.getDate();
        String other$date = other.getDate();
        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
            return false;
        }
        List<CloudAvgTimeStoreVO> this$cloudAvgTimeStoreList = this.getCloudAvgTimeStoreList();
        List<CloudAvgTimeStoreVO> other$cloudAvgTimeStoreList = other.getCloudAvgTimeStoreList();
        return !(this$cloudAvgTimeStoreList == null ? other$cloudAvgTimeStoreList != null : !((Object)this$cloudAvgTimeStoreList).equals(other$cloudAvgTimeStoreList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CloudAvgTimeVO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : $date.hashCode());
        List<CloudAvgTimeStoreVO> $cloudAvgTimeStoreList = this.getCloudAvgTimeStoreList();
        result = result * 59 + ($cloudAvgTimeStoreList == null ? 43 : ((Object)$cloudAvgTimeStoreList).hashCode());
        return result;
    }

    public String toString() {
        return "CloudAvgTimeVO(date=" + this.getDate() + ", cloudAvgTimeStoreList=" + this.getCloudAvgTimeStoreList() + ")";
    }

    public static class CloudAvgTimeStoreVO {
        private Double avgTime;
        private String remark;
        private String storeName;

        public Double getAvgTime() {
            return this.avgTime;
        }

        public String getRemark() {
            return this.remark;
        }

        public String getStoreName() {
            return this.storeName;
        }

        public void setAvgTime(Double avgTime) {
            this.avgTime = avgTime;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public void setStoreName(String storeName) {
            this.storeName = storeName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CloudAvgTimeStoreVO)) {
                return false;
            }
            CloudAvgTimeStoreVO other = (CloudAvgTimeStoreVO)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Double this$avgTime = this.getAvgTime();
            Double other$avgTime = other.getAvgTime();
            if (this$avgTime == null ? other$avgTime != null : !((Object)this$avgTime).equals(other$avgTime)) {
                return false;
            }
            String this$remark = this.getRemark();
            String other$remark = other.getRemark();
            if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
                return false;
            }
            String this$storeName = this.getStoreName();
            String other$storeName = other.getStoreName();
            return !(this$storeName == null ? other$storeName != null : !this$storeName.equals(other$storeName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CloudAvgTimeStoreVO;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Double $avgTime = this.getAvgTime();
            result = result * 59 + ($avgTime == null ? 43 : ((Object)$avgTime).hashCode());
            String $remark = this.getRemark();
            result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
            String $storeName = this.getStoreName();
            result = result * 59 + ($storeName == null ? 43 : $storeName.hashCode());
            return result;
        }

        public String toString() {
            return "CloudAvgTimeVO.CloudAvgTimeStoreVO(avgTime=" + this.getAvgTime() + ", remark=" + this.getRemark() + ", storeName=" + this.getStoreName() + ")";
        }
    }
}

