/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.base;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ovopark.cloud.DTO.WatchServiceRecordDTO;
import com.ovopark.cloud.base.PageBaseQuery;

public class PageBaseResult<T> {
    private Long totalNum = 0L;
    private Long page = 0L;
    private Long currentPage = 0L;
    private Long limit = 0L;
    private Long skip = 0L;
    private T data;

    public void initFromCloudManageFilterQuery(IPage selectPage, PageBaseQuery query) {
        this.limit = query.getLimit();
        this.skip = query.getSkip();
        this.currentPage = selectPage.getCurrent();
        this.page = selectPage.getPages();
        this.totalNum = selectPage.getTotal();
    }

    public void initFromCloudManageFilterQuery(IPage selectPage, Integer pageNum, Integer pageSize) {
        this.limit = (long)pageSize;
        this.currentPage = selectPage.getCurrent();
        this.page = selectPage.getPages();
        this.totalNum = selectPage.getTotal();
    }

    public void initWatchServiceRecordDTO(WatchServiceRecordDTO serviceRecordList, PageBaseQuery query) {
        this.limit = query.getLimit();
        this.skip = query.getSkip();
        this.currentPage = (long)serviceRecordList.getCurrent();
        this.page = (long)serviceRecordList.getPages();
        this.totalNum = (long)serviceRecordList.getTotal();
    }

    public void initFromCloudManageFilterQueryPage(IPage selectPage, PageBaseQuery query) {
        if (query != null) {
            this.limit = query.getLimit();
            this.skip = query.getSkip();
        }
        if (selectPage != null && selectPage.getRecords() != null && selectPage.getRecords().size() > 0) {
            this.data = selectPage.getRecords();
            this.currentPage = selectPage.getCurrent();
            this.page = selectPage.getPages();
            this.totalNum = selectPage.getTotal();
        }
    }

    public Long getTotalNum() {
        return this.totalNum;
    }

    public Long getPage() {
        return this.page;
    }

    public Long getCurrentPage() {
        return this.currentPage;
    }

    public Long getLimit() {
        return this.limit;
    }

    public Long getSkip() {
        return this.skip;
    }

    public T getData() {
        return this.data;
    }

    public void setTotalNum(Long totalNum) {
        this.totalNum = totalNum;
    }

    public void setPage(Long page) {
        this.page = page;
    }

    public void setCurrentPage(Long currentPage) {
        this.currentPage = currentPage;
    }

    public void setLimit(Long limit) {
        this.limit = limit;
    }

    public void setSkip(Long skip) {
        this.skip = skip;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageBaseResult)) {
            return false;
        }
        PageBaseResult other = (PageBaseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalNum = this.getTotalNum();
        Long other$totalNum = other.getTotalNum();
        if (this$totalNum == null ? other$totalNum != null : !((Object)this$totalNum).equals(other$totalNum)) {
            return false;
        }
        Long this$page = this.getPage();
        Long other$page = other.getPage();
        if (this$page == null ? other$page != null : !((Object)this$page).equals(other$page)) {
            return false;
        }
        Long this$currentPage = this.getCurrentPage();
        Long other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Long this$limit = this.getLimit();
        Long other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Long this$skip = this.getSkip();
        Long other$skip = other.getSkip();
        if (this$skip == null ? other$skip != null : !((Object)this$skip).equals(other$skip)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageBaseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalNum = this.getTotalNum();
        result = result * 59 + ($totalNum == null ? 43 : ((Object)$totalNum).hashCode());
        Long $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : ((Object)$page).hashCode());
        Long $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Long $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Long $skip = this.getSkip();
        result = result * 59 + ($skip == null ? 43 : ((Object)$skip).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "PageBaseResult(totalNum=" + this.getTotalNum() + ", page=" + this.getPage() + ", currentPage=" + this.getCurrentPage() + ", limit=" + this.getLimit() + ", skip=" + this.getSkip() + ", data=" + this.getData() + ")";
    }
}

