/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.common;

import com.ovopark.cloud.common.ExceptionMessage;
import com.ovopark.cloud.common.Result;
import com.ovopark.cloud.exception.CloudWatchException;
import java.io.Serializable;

public class ResultUtil
implements Serializable {
    public static <T> Result<T> success() {
        Result result = new Result();
        result.setCode(200);
        result.setMsg("success");
        return result;
    }

    public static <T> Result<T> success(String msg) {
        Result result = new Result();
        result.setCode(200);
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> success(String message, T data) {
        Result<T> result = new Result<T>();
        result.setCode(200);
        result.setData(data);
        result.setMsg(message);
        return result;
    }

    public static <T> Result<T> success(T data) {
        Result<T> result = new Result<T>();
        result.setCode(200);
        result.setData(data);
        result.setMsg("success");
        return result;
    }

    public static <T> Result<T> error() {
        Result result = new Result();
        result.setCode(500);
        result.setMsg("error");
        return result;
    }

    public static <T> Result<T> error(String msg) {
        Result result = new Result();
        result.setCode(500);
        result.setMsg(msg);
        return result;
    }

    public static <T> Result<T> error(Integer code, String msg) {
        Result result = new Result();
        result.setCode(code);
        result.setMsg(msg);
        result.setData(null);
        return result;
    }

    public static Result<ExceptionMessage> error(Integer code, String msg, String data) {
        Result<ExceptionMessage> result = new Result<ExceptionMessage>();
        result.setCode(code);
        result.setMsg(msg);
        ExceptionMessage exceptionMessage = new ExceptionMessage();
        exceptionMessage.setErrorMsg(msg);
        result.setData(exceptionMessage);
        return result;
    }

    public static Result<ExceptionMessage> error(CloudWatchException exception) {
        Result<ExceptionMessage> result = new Result<ExceptionMessage>();
        result.setCode(exception.getErrCode());
        result.setMsg(exception.getErrMsg());
        ExceptionMessage exceptionMessage = new ExceptionMessage();
        exceptionMessage.setErrorMsg(exception.getErrMsg());
        result.setData(exceptionMessage);
        return result;
    }
}

