/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.common.base;

import com.ovopark.cloud.Mo.DepartmentPageListMo;
import com.ovopark.cloud.common.base.BaseDTO;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.stereotype.Component;

@Component
public class AppUtil {
    private static final Logger log = LoggerFactory.getLogger(AppUtil.class);

    public static void main(String[] args) {
        System.out.println(AppUtil.formatSeconds(0L));
        System.out.println(AppUtil.formatSeconds(1L));
        System.out.println(AppUtil.formatSeconds(61L));
        System.out.println(AppUtil.formatSeconds(3661L));
        System.out.println(AppUtil.formatSeconds(133361L));
    }

    public static DepartmentPageListMo toDutyGuardDeptFeignParam(BaseDTO baseDTO) {
        DepartmentPageListMo baseParam = baseDTO.toBaseParam(DepartmentPageListMo::new);
        baseParam.setBizDataRange(2);
        baseParam.setSelectInfoLevel(2);
        baseParam.setIsDutyGuardDept(true);
        baseParam.setFilterClose(true);
        if (baseParam.getPageSize() == null) {
            baseParam.setPageNumber(1);
            baseParam.setPageSize(1000000);
        }
        return baseParam;
    }

    public static <T> T copyProperties(Object source, T target) {
        return AppUtil.copyProperties(source, target, true);
    }

    public static <T> T copyProperties(Object source, T target, boolean ignoreNull) {
        if (source != null && target != null) {
            if (ignoreNull) {
                String[] nullPropertyNames = AppUtil.getNullPropertyNames(source);
                BeanUtils.copyProperties((Object)source, target, (String[])nullPropertyNames);
            } else {
                BeanUtils.copyProperties((Object)source, target);
            }
        }
        return target;
    }

    public static String[] getNullPropertyNames(Object source) {
        BeanWrapperImpl src = new BeanWrapperImpl(source);
        PropertyDescriptor[] pds = src.getPropertyDescriptors();
        HashSet<String> emptyNames = new HashSet<String>();
        for (PropertyDescriptor pd : pds) {
            Object srcValue = src.getPropertyValue(pd.getName());
            if (srcValue != null) continue;
            emptyNames.add(pd.getName());
        }
        String[] result = new String[emptyNames.size()];
        return emptyNames.toArray(result);
    }

    public static String formatSeconds(long totalSeconds) {
        if (totalSeconds < 0L) {
            throw new IllegalArgumentException("\u79d2\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570");
        }
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder result = new StringBuilder();
        if (days > 0L) {
            result.append(days).append("\u5929");
        }
        if (hours > 0L) {
            result.append(hours).append("\u5c0f\u65f6");
        }
        if (minutes > 0L || days == 0L && hours == 0L) {
            result.append(minutes).append("\u5206\u949f");
        }
        if (seconds > 0L) {
            result.append(seconds).append("\u79d2");
        }
        return result.toString();
    }

    public static void printDefaultJsonString(Object object) {
    }

    public static String getPhone(String phone) {
        if (phone == null || phone.length() != 11) {
            return phone;
        }
        return phone.substring(0, 3) + "****" + phone.substring(phone.length() - 4);
    }
}

