/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.common.base;

import com.ovopark.cloud.DTO.ThreadUserDTO;
import com.ovopark.cloud.VO.OvoparkUserInfoEntity;
import com.ovopark.cloud.common.RequestContext;
import com.ovopark.cloud.common.base.BaseModel;
import com.ovopark.cloud.common.base.BaseParamVo;
import com.ovopark.cloud.common.base.PageVo;
import com.ovopark.cloud.exception.CloudWatchErrorCode;
import com.ovopark.cloud.exception.CloudWatchException;
import com.ovopark.module.shared.BaseResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class BaseDTO
extends BaseModel {
    private Integer pageSize;
    private Integer pageNumber;
    private Integer enterpriseId;
    private Integer currentUserId;
    private Integer currentGroupId;
    private Integer currentIsAgency;
    private Boolean currentIsSuperAdmin;
    private Locale currentLocale;
    private Integer bizDataRange;

    public BaseDTO() {
    }

    public BaseDTO(Integer pageSize, Integer pageNumber) {
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
    }

    public BaseDTO verifyCurUser() {
        OvoparkUserInfoEntity userInfo;
        ThreadUserDTO user = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (user == null || user.getUserData() == null || (userInfo = user.getUserData().getData()) == null || userInfo.getId() == null) {
            throw new CloudWatchException(CloudWatchErrorCode.TOKEN_NOT_INVALID);
        }
        this.setCurrentUserId(userInfo.getId());
        this.setCurrentGroupId(userInfo.getGroupId());
        if (this.getCurrentGroupId() != null || this.getBizDataRange() == null) {
            this.setBizDataRange(1);
        }
        return this;
    }

    public Integer getGroupId2(Integer enterpriseId) {
        OvoparkUserInfoEntity userInfo;
        ThreadUserDTO user = (ThreadUserDTO)RequestContext.getCurrentContext().getValue("threadUserInfo");
        if (user == null || user.getUserData() == null || (userInfo = user.getUserData().getData()) == null || userInfo.getGroupId() == null) {
            return enterpriseId == null ? this.getEnterpriseId() : enterpriseId;
        }
        return userInfo.getGroupId();
    }

    public BaseDTO setUserIsSuperAdmin(BiFunction<Integer, Integer, BaseResult<Boolean>> function) {
        this.setCurrentIsSuperAdmin(false);
        if (this.getCurrentIsAgency() != null && (this.getCurrentIsAgency() == 1 || this.getCurrentIsAgency() == 2)) {
            this.setCurrentIsSuperAdmin(true);
        } else if (this.getCurrentUserId() != null) {
            BaseResult<Boolean> booleanBaseResult = function.apply(this.getCurrentUserId(), this.getCurrentGroupId());
            if (booleanBaseResult.getIsError().booleanValue() || booleanBaseResult.getData() == null) {
                CloudWatchException commonException = new CloudWatchException(999, "\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f\u5931\u8d25");
                throw commonException;
            }
            this.setCurrentIsSuperAdmin((Boolean)booleanBaseResult.getData());
        }
        return this;
    }

    public <E> PageVo<E> pageByList(List<E> list) {
        PageVo<Object> pageVo = new PageVo<Object>();
        if (list == null) {
            list = new ArrayList();
        }
        Integer pageSize = this.getPageSize();
        Integer pageNumber = this.getPageNumber();
        int total = list.size();
        pageVo.setTotal(total);
        if (pageSize != null && pageSize != -1) {
            int fromIndex = (pageNumber - 1) * pageSize;
            if (fromIndex >= total) {
                pageVo.setRecords(new ArrayList());
            } else {
                int toIndex = Math.min(fromIndex + pageSize, total);
                List pageList = list.stream().skip(fromIndex).limit(toIndex - fromIndex).collect(Collectors.toList());
                pageVo.setRecords(pageList);
            }
        } else {
            pageVo.setRecords(list);
        }
        return pageVo;
    }

    public <E extends BaseParamVo> E toBaseParam(Supplier<E> supplier) {
        Integer userId = this.verifyCurUser().getCurrentUserId();
        Integer groupId2 = this.getGroupId2(null);
        BaseParamVo baseParam = (BaseParamVo)supplier.get();
        baseParam.setPageNumber(this.getPageNumber());
        baseParam.setPageSize(this.getPageSize());
        baseParam.setCurUserId(userId);
        baseParam.setEnterpriseId(groupId2);
        return (E)baseParam;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public Integer getPageNumber() {
        return this.pageNumber;
    }

    @Override
    public Integer getEnterpriseId() {
        return this.enterpriseId;
    }

    public Integer getCurrentUserId() {
        return this.currentUserId;
    }

    public Integer getCurrentGroupId() {
        return this.currentGroupId;
    }

    public Integer getCurrentIsAgency() {
        return this.currentIsAgency;
    }

    public Boolean getCurrentIsSuperAdmin() {
        return this.currentIsSuperAdmin;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public Integer getBizDataRange() {
        return this.bizDataRange;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    @Override
    public void setEnterpriseId(Integer enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public void setCurrentUserId(Integer currentUserId) {
        this.currentUserId = currentUserId;
    }

    public void setCurrentGroupId(Integer currentGroupId) {
        this.currentGroupId = currentGroupId;
    }

    public void setCurrentIsAgency(Integer currentIsAgency) {
        this.currentIsAgency = currentIsAgency;
    }

    public void setCurrentIsSuperAdmin(Boolean currentIsSuperAdmin) {
        this.currentIsSuperAdmin = currentIsSuperAdmin;
    }

    public void setCurrentLocale(Locale currentLocale) {
        this.currentLocale = currentLocale;
    }

    public void setBizDataRange(Integer bizDataRange) {
        this.bizDataRange = bizDataRange;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseDTO)) {
            return false;
        }
        BaseDTO other = (BaseDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$pageNumber = this.getPageNumber();
        Integer other$pageNumber = other.getPageNumber();
        if (this$pageNumber == null ? other$pageNumber != null : !((Object)this$pageNumber).equals(other$pageNumber)) {
            return false;
        }
        Integer this$enterpriseId = this.getEnterpriseId();
        Integer other$enterpriseId = other.getEnterpriseId();
        if (this$enterpriseId == null ? other$enterpriseId != null : !((Object)this$enterpriseId).equals(other$enterpriseId)) {
            return false;
        }
        Integer this$currentUserId = this.getCurrentUserId();
        Integer other$currentUserId = other.getCurrentUserId();
        if (this$currentUserId == null ? other$currentUserId != null : !((Object)this$currentUserId).equals(other$currentUserId)) {
            return false;
        }
        Integer this$currentGroupId = this.getCurrentGroupId();
        Integer other$currentGroupId = other.getCurrentGroupId();
        if (this$currentGroupId == null ? other$currentGroupId != null : !((Object)this$currentGroupId).equals(other$currentGroupId)) {
            return false;
        }
        Integer this$currentIsAgency = this.getCurrentIsAgency();
        Integer other$currentIsAgency = other.getCurrentIsAgency();
        if (this$currentIsAgency == null ? other$currentIsAgency != null : !((Object)this$currentIsAgency).equals(other$currentIsAgency)) {
            return false;
        }
        Boolean this$currentIsSuperAdmin = this.getCurrentIsSuperAdmin();
        Boolean other$currentIsSuperAdmin = other.getCurrentIsSuperAdmin();
        if (this$currentIsSuperAdmin == null ? other$currentIsSuperAdmin != null : !((Object)this$currentIsSuperAdmin).equals(other$currentIsSuperAdmin)) {
            return false;
        }
        Integer this$bizDataRange = this.getBizDataRange();
        Integer other$bizDataRange = other.getBizDataRange();
        if (this$bizDataRange == null ? other$bizDataRange != null : !((Object)this$bizDataRange).equals(other$bizDataRange)) {
            return false;
        }
        Locale this$currentLocale = this.getCurrentLocale();
        Locale other$currentLocale = other.getCurrentLocale();
        return !(this$currentLocale == null ? other$currentLocale != null : !((Object)this$currentLocale).equals(other$currentLocale));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof BaseDTO;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $pageNumber = this.getPageNumber();
        result = result * 59 + ($pageNumber == null ? 43 : ((Object)$pageNumber).hashCode());
        Integer $enterpriseId = this.getEnterpriseId();
        result = result * 59 + ($enterpriseId == null ? 43 : ((Object)$enterpriseId).hashCode());
        Integer $currentUserId = this.getCurrentUserId();
        result = result * 59 + ($currentUserId == null ? 43 : ((Object)$currentUserId).hashCode());
        Integer $currentGroupId = this.getCurrentGroupId();
        result = result * 59 + ($currentGroupId == null ? 43 : ((Object)$currentGroupId).hashCode());
        Integer $currentIsAgency = this.getCurrentIsAgency();
        result = result * 59 + ($currentIsAgency == null ? 43 : ((Object)$currentIsAgency).hashCode());
        Boolean $currentIsSuperAdmin = this.getCurrentIsSuperAdmin();
        result = result * 59 + ($currentIsSuperAdmin == null ? 43 : ((Object)$currentIsSuperAdmin).hashCode());
        Integer $bizDataRange = this.getBizDataRange();
        result = result * 59 + ($bizDataRange == null ? 43 : ((Object)$bizDataRange).hashCode());
        Locale $currentLocale = this.getCurrentLocale();
        result = result * 59 + ($currentLocale == null ? 43 : ((Object)$currentLocale).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "BaseDTO(pageSize=" + this.getPageSize() + ", pageNumber=" + this.getPageNumber() + ", enterpriseId=" + this.getEnterpriseId() + ", currentUserId=" + this.getCurrentUserId() + ", currentGroupId=" + this.getCurrentGroupId() + ", currentIsAgency=" + this.getCurrentIsAgency() + ", currentIsSuperAdmin=" + this.getCurrentIsSuperAdmin() + ", currentLocale=" + this.getCurrentLocale() + ", bizDataRange=" + this.getBizDataRange() + ")";
    }
}

