/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.cloud.common.base;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.cloud.common.base.AppUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class CollectionHelper {
    @SafeVarargs
    public static <E> List<E> addAll(Collection<E> ... collectionArray) {
        ArrayList<E> allList = new ArrayList<E>();
        if (collectionArray != null) {
            for (Collection<E> collection : collectionArray) {
                if (!CollectionUtils.isNotEmpty(collection)) continue;
                allList.addAll(collection);
            }
        }
        return allList;
    }

    @SafeVarargs
    public static <E> ListEntity<E> asList(E ... e) {
        return new ListEntity<E>(new ArrayList<E>(Arrays.asList(e)));
    }

    public static <E> List<E> copy2List(List<?> sourceList, Supplier<E> dataSupplier) {
        if (sourceList == null) {
            return null;
        }
        ArrayList<E> dataList = new ArrayList<E>();
        for (Object t : sourceList) {
            E e = AppUtil.copyProperties(t, dataSupplier.get(), true);
            dataList.add(e);
        }
        return dataList;
    }

    public static <E> ListEntity<E> listEntity(Supplier<E> dataSupplier) {
        return new ListEntity<E>(dataSupplier);
    }

    public static <K, V> MapEntity<K, V> asMap(K k, V v) {
        HashMap<K, V> kvHashMap = new HashMap<K, V>();
        kvHashMap.put(k, v);
        return new MapEntity(kvHashMap);
    }

    @SafeVarargs
    public static <E> Collection<E> getIntersection(Collection<E> sourceCollection, Collection<E> ... filterCollection) {
        ArrayList empty = new ArrayList();
        if (CollectionUtils.isEmpty(sourceCollection) || filterCollection == null || filterCollection.length == 0) {
            return empty;
        }
        ArrayList<E> arrayList = new ArrayList<E>(sourceCollection);
        for (Collection<E> es : filterCollection) {
            if (CollectionUtils.isEmpty(es)) {
                return empty;
            }
            arrayList.retainAll(es);
            if (!CollectionUtils.isEmpty(arrayList)) continue;
            return arrayList;
        }
        return arrayList;
    }

    public static <E> Collection<E> getIntersectionNew(Collection<E> baseCollection, Collection<E> filterCollection) {
        if (CollectionUtils.isEmpty(filterCollection)) {
            return filterCollection;
        }
        if (CollectionUtils.isNotEmpty(baseCollection)) {
            ArrayList<E> arrayList = new ArrayList<E>(baseCollection);
            arrayList.retainAll(filterCollection);
            return arrayList;
        }
        return filterCollection;
    }

    public static void main(String[] args) {
        List<Integer> integerList = Arrays.asList(1, 2, 3);
        List<Integer> integerList2 = Arrays.asList(2, 3, 4);
        Collection<Integer> intersection = CollectionHelper.getIntersectionNew(integerList, integerList2);
        System.out.println(intersection);
    }

    public static class MapEntity<K, V> {
        private final Map<K, V> map;

        public MapEntity(Map<K, V> map) {
            this.map = map == null ? new HashMap() : map;
        }

        public MapEntity<K, V> put(K k, V v) {
            this.map.put(k, v);
            return this;
        }

        public Map<K, V> get() {
            return this.map;
        }
    }

    public static class ListEntity<E> {
        private final List<E> list;
        private Supplier<E> dataSupplier;

        public ListEntity(List<E> list) {
            this.list = list == null ? new ArrayList() : list;
        }

        public ListEntity(Supplier<E> dataSupplier) {
            this.dataSupplier = dataSupplier;
            this.list = new ArrayList();
        }

        public ListEntity<E> add(E e) {
            this.list.add(e);
            return this;
        }

        public <T> List<E> copyFrom(List<T> sourceList) {
            return CollectionHelper.copy2List(sourceList, this.dataSupplier);
        }

        public List<E> get() {
            return this.list;
        }

        public Set<E> getSet() {
            return new HashSet<E>(this.list);
        }
    }
}

